/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.certificateutil;

import io.debezium.testing.system.tools.certificateutil.CertificateWrapper;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Map;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;

public class CertUtil {
    public static final String KEYSTORE_PASSWORD = "password";

    public static void stringToConfigMap(String project, String data, String configMapName, String fileNameInConfigMap, OpenShiftClient ocp) {
        ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(configMapName)).build())).withData(Map.of(fileNameInConfigMap, data))).build();
        ((NonNamespaceOperation)ocp.configMaps().inNamespace(project)).createOrReplace((Object)configMap);
    }

    public static void keystoreToConfigMap(String project, KeyStore keyStore, String configMapName, String fileNameInConfigMap, OpenShiftClient ocp) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        char[] pwdArray = KEYSTORE_PASSWORD.toCharArray();
        try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
            keyStore.store(fos, pwdArray);
            ConfigMap configMap = ((ConfigMapBuilder)((ConfigMapBuilder)new ConfigMapBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(configMapName)).build())).withBinaryData(Map.of(fileNameInConfigMap, Base64.getEncoder().encodeToString(fos.toByteArray())))).build();
            ((NonNamespaceOperation)ocp.configMaps().inNamespace(project)).createOrReplace((Object)configMap);
        }
    }

    public static String exportToBase64PEMString(PrivateKey privateKey) throws IOException {
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
            pw.writeObject((Object)privateKey);
        }
        return sw.toString();
    }

    public static String exportToBase64PEMString(X509CertificateHolder holder) throws CertificateException, IOException {
        return CertUtil.exportToBase64PEMString(CertUtil.convertHolderToCert(holder));
    }

    private static X509Certificate convertHolderToCert(X509CertificateHolder holder) throws CertificateException {
        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        return converter.getCertificate(holder);
    }

    private static String exportToBase64PEMString(X509Certificate x509Cert) throws IOException {
        StringWriter sw = new StringWriter();
        try (JcaPEMWriter pw = new JcaPEMWriter((Writer)sw);){
            pw.writeObject((Object)x509Cert);
        }
        return sw.toString();
    }

    public static String exportCertificateToMongoCompatiblePem(CertificateWrapper cert, CertificateWrapper ca) throws IOException, CertificateException {
        return CertUtil.exportToBase64PEMString(cert.getKeyPair().getPrivate()) + CertUtil.exportToBase64PEMString(cert.getHolder()) + CertUtil.exportToBase64PEMString(ca.getHolder());
    }
}

