/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.builders;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.common.template.PodTemplate;
import io.strimzi.api.kafka.model.common.template.PodTemplateBuilder;
import io.strimzi.api.kafka.model.kafka.EphemeralStorage;
import io.strimzi.api.kafka.model.kafka.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.kafka.Kafka;
import io.strimzi.api.kafka.model.kafka.KafkaBuilder;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpec;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpecBuilder;
import io.strimzi.api.kafka.model.kafka.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.kafka.KafkaFluent;
import io.strimzi.api.kafka.model.kafka.KafkaSpecFluent;
import io.strimzi.api.kafka.model.kafka.SingleVolumeStorage;
import io.strimzi.api.kafka.model.kafka.Storage;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpec;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpecBuilder;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityTopicOperatorSpec;
import io.strimzi.api.kafka.model.kafka.entityoperator.EntityUserOperatorSpec;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListener;
import io.strimzi.api.kafka.model.kafka.listener.GenericKafkaListenerBuilder;
import io.strimzi.api.kafka.model.kafka.listener.KafkaListenerType;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePool;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolBuilder;
import io.strimzi.api.kafka.model.nodepool.KafkaNodePoolFluent;
import io.strimzi.api.kafka.model.nodepool.ProcessRoles;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpec;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpecBuilder;
import io.strimzi.api.kafka.model.zookeeper.ZookeeperClusterSpecFluent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FabricKafkaBuilder
extends FabricBuilderWrapper<FabricKafkaBuilder, KafkaBuilder, Kafka> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricKafkaBuilder.class);
    public static String DEFAULT_KAFKA_NAME = "debezium-kafka-cluster";
    public static String DEFAULT_NODE_POOL_NAME = "node-pool";
    private static Boolean useKraft;

    private FabricKafkaBuilder(KafkaBuilder kafkaBuilder) {
        super(kafkaBuilder);
    }

    @Override
    public Kafka build() {
        return ((KafkaBuilder)this.builder).build();
    }

    public static FabricKafkaBuilder base() {
        KafkaClusterSpec kafka = FabricKafkaBuilder.defaultKafkaSpec();
        EntityOperatorSpec entityOperator = FabricKafkaBuilder.defaultKafkaEntityOperatorSpec();
        KafkaBuilder builder = (KafkaBuilder)((KafkaFluent.SpecNested)((KafkaFluent.SpecNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName(DEFAULT_KAFKA_NAME)).endMetadata()).withNewSpec().withKafka(kafka)).withEntityOperator(entityOperator)).endSpec();
        if (FabricKafkaBuilder.shouldKRaftBeUsed()) {
            Map<String, String> clusterAnnotations = Map.of("strimzi.io/node-pools", "enabled", "strimzi.io/kraft", "enabled");
            ((KafkaFluent.SpecNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)builder.editMetadata().withAnnotations(clusterAnnotations)).endMetadata()).editSpec().withZookeeper(null)).endSpec();
        } else {
            ((KafkaFluent.SpecNested)builder.editSpec().withZookeeper(FabricKafkaBuilder.defaultKafkaZookeeperSpec())).endSpec();
        }
        return new FabricKafkaBuilder(builder);
    }

    public FabricKafkaBuilder withPullSecret(Optional<Secret> maybePullSecret) {
        maybePullSecret.map(s -> s.getMetadata().getName()).ifPresent(this::withPullSecret);
        return (FabricKafkaBuilder)this.self();
    }

    public FabricKafkaBuilder withPullSecret(String pullSecretName) {
        PodTemplate podTemplate = ((PodTemplateBuilder)new PodTemplateBuilder().addNewImagePullSecret(pullSecretName)).build();
        ((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((EntityOperatorSpecFluent.TemplateNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.TemplateNested)((KafkaBuilder)this.builder).editSpec().editKafka().withNewTemplate().withPod(podTemplate)).endTemplate()).endKafka()).editEntityOperator().withNewTemplate().withPod(podTemplate)).endTemplate()).endEntityOperator()).endSpec();
        if (!FabricKafkaBuilder.shouldKRaftBeUsed()) {
            ((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((ZookeeperClusterSpecFluent.TemplateNested)((KafkaBuilder)this.builder).editSpec().editZookeeper().withNewTemplate().withPod(podTemplate)).endTemplate()).endZookeeper()).endSpec();
        }
        return (FabricKafkaBuilder)this.self();
    }

    public static boolean shouldKRaftBeUsed() {
        if (useKraft == null) {
            ComparableVersion kafkaVersion = new ComparableVersion(ConfigProperties.STRIMZI_VERSION_KAFKA);
            ComparableVersion strimziVersion = new ComparableVersion(ConfigProperties.STRIMZI_OPERATOR_VERSION);
            useKraft = false;
            if (ConfigProperties.FORCE_KRAFT) {
                useKraft = true;
                LOGGER.info("KRaft forced by configuration.");
            } else if (kafkaVersion.compareTo(new ComparableVersion("4.0.0")) >= 0) {
                useKraft = true;
                LOGGER.info("Kafka version >= 4.0.0 detected.");
            } else if (!ConfigProperties.PRODUCT_BUILD && strimziVersion.compareTo(new ComparableVersion("0.46.0")) >= 0) {
                useKraft = true;
                LOGGER.info("Strimzi version >= 0.46.0.");
            }
            if (useKraft.booleanValue()) {
                LOGGER.info("Using Kafka with KRaft is enabled.");
            } else {
                LOGGER.warn("Using Kafka with Zookeeper is enabled. This way will become deprecated soon.");
            }
        }
        return useKraft;
    }

    private static KafkaClusterSpec defaultKafkaSpec() {
        Map<String, Object> config = FabricKafkaBuilder.defaultKafkaConfig();
        List<GenericKafkaListener> listeners = FabricKafkaBuilder.defaultKafkaListeners();
        KafkaClusterSpecBuilder kafkaClusterSpec = (KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)((KafkaClusterSpecBuilder)new KafkaClusterSpecBuilder().withConfig(config)).withVersion(ConfigProperties.STRIMZI_VERSION_KAFKA)).withListeners(listeners);
        if (!FabricKafkaBuilder.shouldKRaftBeUsed()) {
            ((KafkaClusterSpecBuilder)kafkaClusterSpec.withStorage((Storage)new EphemeralStorage())).withReplicas(Integer.valueOf(3));
        }
        return kafkaClusterSpec.build();
    }

    private static List<GenericKafkaListener> defaultKafkaListeners() {
        GenericKafkaListener plainInternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("plain")).withPort(9092)).withType(KafkaListenerType.INTERNAL)).build();
        GenericKafkaListener tlsInternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("tls")).withPort(9093)).withType(KafkaListenerType.INTERNAL)).withTls(true)).build();
        GenericKafkaListener routeExternal = ((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)((GenericKafkaListenerBuilder)new GenericKafkaListenerBuilder().withName("external")).withPort(9094)).withType(KafkaListenerType.ROUTE)).withTls(true)).build();
        return Arrays.asList(plainInternal, tlsInternal, routeExternal);
    }

    private static Map<String, Object> defaultKafkaConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("offsets.topic.replication.factor", 1);
        config.put("transaction.state.log.replication.factor", 1);
        config.put("transaction.state.log.min.isr", 1);
        if (FabricKafkaBuilder.shouldKRaftBeUsed()) {
            config.put("default.replication.factor", 3);
            config.put("min.insync.replicas", 2);
        }
        return config;
    }

    private static ZookeeperClusterSpec defaultKafkaZookeeperSpec() {
        return ((ZookeeperClusterSpecBuilder)((ZookeeperClusterSpecBuilder)new ZookeeperClusterSpecBuilder().withStorage((SingleVolumeStorage)new EphemeralStorage())).withReplicas(1)).build();
    }

    private static EntityOperatorSpec defaultKafkaEntityOperatorSpec() {
        EntityTopicOperatorSpec topicOperator = new EntityTopicOperatorSpec();
        EntityUserOperatorSpec userOperator = new EntityUserOperatorSpec();
        return ((EntityOperatorSpecBuilder)((EntityOperatorSpecBuilder)new EntityOperatorSpecBuilder().withTopicOperator(topicOperator)).withUserOperator(userOperator)).build();
    }

    public KafkaNodePool defaultKafkaNodePool() {
        LOGGER.info("Creating Node Pool for kafka cluster: " + DEFAULT_KAFKA_NAME);
        return ((KafkaNodePoolBuilder)((KafkaNodePoolFluent.SpecNested)((KafkaNodePoolFluent.SpecNested)((KafkaNodePoolFluent.SpecNested)((KafkaNodePoolBuilder)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)new KafkaNodePoolBuilder().withNewMetadata().withName(DEFAULT_NODE_POOL_NAME)).withLabels(Map.of("strimzi.io/cluster", DEFAULT_KAFKA_NAME))).endMetadata()).withNewSpec().withReplicas(3)).withRoles(List.of(ProcessRoles.CONTROLLER, ProcessRoles.BROKER))).withStorage((Storage)new EphemeralStorageBuilder().build())).endSpec()).build();
    }
}

