/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.db2;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.AbstractDockerSqlDatabaseController;
import io.debezium.testing.system.tools.databases.SqlDatabaseClient;
import io.debezium.testing.system.tools.databases.db2.OcpDB2Controller;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Db2Container;

public class DockerDB2Controller
extends AbstractDockerSqlDatabaseController<Db2Container> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpDB2Controller.class);

    public DockerDB2Controller(Db2Container container) {
        super(container);
    }

    @Override
    public int getDatabasePort() {
        return 50000;
    }

    @Override
    public void initialize() throws InterruptedException {
        LOGGER.info("Waiting until DB2 instance is ready");
        SqlDatabaseClient client = this.getDatabaseClient(ConfigProperties.DATABASE_DB2_DBZ_USERNAME, ConfigProperties.DATABASE_DB2_DBZ_PASSWORD);
        try (Connection connection = client.connect();){
            LOGGER.info("Database connection established successfully!");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

