/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.builders;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.artifacts.OcpArtifactServerController;
import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.debezium.testing.system.tools.kafka.builders.FabricKafkaBuilder;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelectorBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.strimzi.api.kafka.model.common.CertSecretSource;
import io.strimzi.api.kafka.model.common.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.common.ClientTls;
import io.strimzi.api.kafka.model.common.ClientTlsBuilder;
import io.strimzi.api.kafka.model.common.ContainerEnvVar;
import io.strimzi.api.kafka.model.common.ContainerEnvVarBuilder;
import io.strimzi.api.kafka.model.common.ExternalLoggingFluent;
import io.strimzi.api.kafka.model.common.metrics.JmxPrometheusExporterMetricsFluent;
import io.strimzi.api.kafka.model.common.template.ContainerTemplateBuilder;
import io.strimzi.api.kafka.model.connect.AbstractKafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationBuilder;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSource;
import io.strimzi.api.kafka.model.connect.ExternalConfigurationVolumeSourceBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnect;
import io.strimzi.api.kafka.model.connect.KafkaConnectBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnectFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectSpecFluent;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplate;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplateBuilder;
import io.strimzi.api.kafka.model.connect.KafkaConnectTemplateFluent;
import io.strimzi.api.kafka.model.connect.build.BuildFluent;
import io.strimzi.api.kafka.model.connect.build.Plugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FabricKafkaConnectBuilder
extends FabricBuilderWrapper<FabricKafkaConnectBuilder, KafkaConnectBuilder, KafkaConnect> {
    public static String DEFAULT_KC_NAME = "connect-cluster";
    public static String KAFKA_CERT_SECRET = FabricKafkaBuilder.DEFAULT_KAFKA_NAME + "-cluster-ca-cert";
    public static String KAFKA_CLIENT_CERT_SECRET = FabricKafkaBuilder.DEFAULT_KAFKA_NAME + "-clients-ca-cert";
    public static String KAFKA_CERT_FILENAME = "ca.crt";
    public static String DEFAULT_BOOSTRAP_SERVER = FabricKafkaBuilder.DEFAULT_KAFKA_NAME + "-kafka-bootstrap:9093";

    protected FabricKafkaConnectBuilder(KafkaConnectBuilder builder) {
        super(builder);
    }

    @Override
    public KafkaConnect build() {
        return ((KafkaConnectBuilder)this.builder).build();
    }

    public boolean hasBuild() {
        return ((KafkaConnectBuilder)this.builder).editSpec().hasBuild();
    }

    public Optional<String> imageStream() {
        if (!this.hasBuild()) {
            return Optional.empty();
        }
        String image = ((KafkaConnectBuilder)this.builder).editSpec().editBuild().buildOutput().getImage();
        return Optional.of(image);
    }

    public static FabricKafkaConnectBuilder base(String bootstrap) {
        Map<String, Object> config = FabricKafkaConnectBuilder.defaultConfig();
        KafkaConnectTemplate template = FabricKafkaConnectBuilder.defaultTemplate();
        ClientTls tls = FabricKafkaConnectBuilder.defaultTLS();
        KafkaConnectBuilder builder = (KafkaConnectBuilder)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectFluent.SpecNested)((KafkaConnectBuilder)((CustomResourceFluent.MetadataNested)new KafkaConnectBuilder().withNewMetadata().withName(DEFAULT_KC_NAME)).endMetadata()).withNewSpec().withBootstrapServers(bootstrap)).withTemplate(template)).withConfig(config)).withReplicas(1)).withTls(tls)).endSpec();
        return new FabricKafkaConnectBuilder(builder);
    }

    public FabricKafkaConnectBuilder withBuild(OcpArtifactServerController artifactServer) {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>(List.of(artifactServer.createDebeziumPlugin("mysql"), artifactServer.createDebeziumPlugin("mariadb"), artifactServer.createDebeziumPlugin("postgres"), artifactServer.createDebeziumPlugin("mongodb"), artifactServer.createDebeziumPlugin("sqlserver"), artifactServer.createDebeziumPlugin("db2", List.of("jdbc/jcc")), artifactServer.createDebeziumPlugin("jdbc")));
        if (ConfigProperties.DATABASE_ORACLE) {
            plugins.add(artifactServer.createDebeziumPlugin("oracle", List.of("jdbc/ojdbc11")));
        }
        return this.withBuild(plugins);
    }

    public FabricKafkaConnectBuilder withBuild(List<Plugin> plugins) {
        ((KafkaConnectFluent.SpecNested)((KafkaConnectSpecFluent.BuildNested)((KafkaConnectSpecFluent.BuildNested)((BuildFluent.ImageStreamOutputNested)((KafkaConnectBuilder)this.builder).editSpec().withNewBuild().withNewImageStreamOutput().withImage("testing-openshift-connect:latest")).endImageStreamOutput()).withPlugins(plugins)).endBuild()).endSpec();
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withConnectorResources(Boolean enabled) {
        return enabled != false ? this.withConnectorResources() : (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withConnectorResources() {
        ((CustomResourceFluent.MetadataNested)((KafkaConnectBuilder)this.builder).editMetadata().addToAnnotations("strimzi.io/use-connector-resources", "true")).endMetadata();
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withPullSecret(Optional<Secret> maybePullSecret) {
        maybePullSecret.map(s -> s.getMetadata().getName()).ifPresent(this::withPullSecret);
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withPullSecret(String pullSecretName) {
        if (((KafkaConnectBuilder)this.builder).editSpec().hasImage()) {
            ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.TemplateNested)((KafkaConnectTemplateFluent.PodNested)((KafkaConnectBuilder)this.builder).editSpec().editTemplate().editOrNewPod().addNewImagePullSecret(pullSecretName)).endPod()).endTemplate()).endSpec();
        }
        if (((KafkaConnectBuilder)this.builder).editSpec().hasBuild()) {
            ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.TemplateNested)((KafkaConnectTemplateFluent.BuildConfigNested)((KafkaConnectBuilder)this.builder).editSpec().editTemplate().editOrNewBuildConfig().withPullSecret(pullSecretName)).endBuildConfig()).endTemplate()).endSpec();
        }
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withLoggingFromConfigMap(ConfigMap configMap) {
        ConfigMapKeySelector configMapKeySelector = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey("log4j.properties")).withName(configMap.getMetadata().getName())).build();
        ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.ExternalLoggingNested)((ExternalLoggingFluent.ValueFromNested)((KafkaConnectBuilder)this.builder).editSpec().withNewExternalLogging().withNewValueFrom().withConfigMapKeyRef(configMapKeySelector)).endValueFrom()).endExternalLogging()).endSpec();
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withMongoCerts() {
        ((KafkaConnectFluent.SpecNested)((KafkaConnectBuilder)this.builder).editSpec().withExternalConfiguration(((ExternalConfigurationBuilder)new ExternalConfigurationBuilder().withVolumes(new ExternalConfigurationVolumeSource[]{((ExternalConfigurationVolumeSourceBuilder)((ExternalConfigurationVolumeSourceBuilder)new ExternalConfigurationVolumeSourceBuilder().withName("keystore")).withConfigMap(((ConfigMapVolumeSourceBuilder)((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName("keystore")).withDefaultMode(Integer.valueOf(272))).build())).build(), ((ExternalConfigurationVolumeSourceBuilder)((ExternalConfigurationVolumeSourceBuilder)new ExternalConfigurationVolumeSourceBuilder().withName("truststore")).withConfigMap(((ConfigMapVolumeSourceBuilder)((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName("truststore")).withDefaultMode(Integer.valueOf(272))).build())).build()})).build())).endSpec();
        return (FabricKafkaConnectBuilder)this.self();
    }

    public FabricKafkaConnectBuilder withMetricsFromConfigMap(ConfigMap configMap) {
        ConfigMapKeySelector configMapKeySelector = ((ConfigMapKeySelectorBuilder)((ConfigMapKeySelectorBuilder)new ConfigMapKeySelectorBuilder().withKey("metrics")).withName(configMap.getMetadata().getName())).build();
        ((KafkaConnectFluent.SpecNested)((AbstractKafkaConnectSpecFluent.JmxPrometheusExporterMetricsConfigNested)((JmxPrometheusExporterMetricsFluent.ValueFromNested)((KafkaConnectBuilder)this.builder).editSpec().withNewJmxPrometheusExporterMetricsConfig().withNewValueFrom().withConfigMapKeyRef(configMapKeySelector)).endValueFrom()).endJmxPrometheusExporterMetricsConfig()).endSpec();
        return (FabricKafkaConnectBuilder)this.self();
    }

    private static KafkaConnectTemplate defaultTemplate() {
        return ((KafkaConnectTemplateBuilder)new KafkaConnectTemplateBuilder().withConnectContainer(((ContainerTemplateBuilder)new ContainerTemplateBuilder().withEnv(new ContainerEnvVar[]{((ContainerEnvVarBuilder)((ContainerEnvVarBuilder)new ContainerEnvVarBuilder().withName("JMX_PORT")).withValue("5000")).build()})).build())).build();
    }

    private static ClientTls defaultTLS() {
        return ((ClientTlsBuilder)new ClientTlsBuilder().withTrustedCertificates(new CertSecretSource[]{((CertSecretSourceBuilder)((CertSecretSourceBuilder)new CertSecretSourceBuilder().withCertificate(KAFKA_CERT_FILENAME)).withSecretName(KAFKA_CERT_SECRET)).build()})).build();
    }

    private static Map<String, Object> defaultConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("config.storage.replication.factor", 1);
        config.put("offset.storage.replication.factor", 1);
        config.put("status.storage.replication.factor", 1);
        return config;
    }
}

