/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.sharded;

import io.debezium.testing.system.tools.databases.mongodb.sharded.ShardKeyRange;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class MongoShardKey {
    private final String collection;
    private final String key;
    private final ShardingType shardingType;
    private final List<ShardKeyRange> keyRanges;

    public MongoShardKey(String collection, String key, ShardingType shardingType) {
        this.collection = collection;
        this.key = key;
        this.shardingType = shardingType;
        this.keyRanges = new LinkedList<ShardKeyRange>();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoShardKey that = (MongoShardKey)o;
        return Objects.equals(this.collection, that.collection) && Objects.equals(this.key, that.key);
    }

    public String getCollection() {
        return this.collection;
    }

    public String getKey() {
        return this.key;
    }

    public ShardingType getShardingType() {
        return this.shardingType;
    }

    public List<ShardKeyRange> getKeyRanges() {
        return this.keyRanges;
    }

    public int hashCode() {
        return Objects.hash(this.collection, this.key);
    }

    public static enum ShardingType {
        HASHED("\"hashed\""),
        RANGED("1");

        private final String value;

        private ShardingType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

