/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.docker;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.docker.ZookeeperContainer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.lifecycle.Startable;

public class KafkaContainer
extends GenericContainer<KafkaContainer> {
    public static final String KAFKA_COMMAND = "kafka";
    public static final int KAFKA_PORT = 9093;
    public static final int KAFKA_BROKER_PORT = 9092;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final int mappedPort = 9093 + COUNTER.getAndIncrement();

    public KafkaContainer(String containerImageName) {
        super(containerImageName);
        this.defaultConfig();
    }

    public KafkaContainer() {
        this(ConfigProperties.DOCKER_IMAGE_KAFKA_RHEL);
    }

    private void defaultConfig() {
        this.addFixedExposedPort(this.mappedPort, 9093);
        this.addExposedPort(this.mappedPort);
        this.withCommand(KAFKA_COMMAND);
        this.withEnv("KAFKA_LISTENERS", "PLAINTEXT://0.0.0.0:9093,BROKER://0.0.0.0:9092");
        this.withEnv("KAFKA_ADVERTISED_LISTENERS", "PLAINTEXT://" + this.getPublicBootstrapAddress() + ",BROKER://" + this.getBootstrapAddress());
        this.withEnv("KAFKA_LISTENER_SECURITY_PROTOCOL_MAP", "BROKER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
        this.withEnv("KAFKA_INTER_BROKER_LISTENER_NAME", "BROKER");
        this.withStartupTimeout(Duration.ofMinutes(WaitConditions.scaled(1L)));
    }

    public KafkaContainer withZookeeper(ZookeeperContainer zookeeper) {
        return ((KafkaContainer)this.dependsOn(new Startable[]{zookeeper})).withZookeeper(zookeeper.getNetwork(), zookeeper.serverAddress());
    }

    public KafkaContainer withZookeeper(Network network, String zookeeperServers) {
        return (KafkaContainer)((KafkaContainer)this.withNetwork(network)).withEnv("ZOOKEEPER_CONNECT", zookeeperServers);
    }

    public String getPublicBootstrapAddress() {
        return this.getContainerIpAddress() + ":" + this.mappedPort;
    }

    public String getBootstrapAddress() {
        return (String)this.getNetworkAliases().get(0) + ":9092";
    }

    protected void containerIsStopped(InspectContainerResponse containerInfo) {
        super.containerIsStopped(containerInfo);
        COUNTER.decrementAndGet();
    }
}

