/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.v1.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.v1.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.OpenShiftUtils;
import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.registry.RegistryController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioController
implements RegistryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioController.class);
    public static final String APICURIO_NAME_LBL = "apicur.io/name";
    protected final OpenShiftClient ocp;
    protected final OkHttpClient http;
    protected final String project;
    protected final String name;
    protected final OpenShiftUtils ocpUtils;
    protected ApicurioRegistry registry;

    public OcpApicurioController(ApicurioRegistry registry, OpenShiftClient ocp, OkHttpClient http) {
        this.registry = registry;
        this.ocp = ocp;
        this.http = http;
        this.project = registry.getMetadata().getNamespace();
        this.name = registry.getMetadata().getName();
        this.ocpUtils = new OpenShiftUtils(ocp);
    }

    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        return (NonNamespaceOperation)this.ocp.resources(ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }

    protected String getPublicRegistryAddress() {
        Awaitility.await().atMost(WaitConditions.scaled(30L), TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).until(() -> !this.getRoutes().isEmpty());
        return this.getRoutes().get(0).getSpec().getHost();
    }

    private List<Route> getRoutes() {
        return ((RouteList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.routes().inNamespace(this.project)).withLabel(APICURIO_NAME_LBL, this.name)).list()).getItems();
    }

    protected Service getRegistryService() {
        List items = ((ServiceList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).withLabel(APICURIO_NAME_LBL, this.name)).list()).getItems();
        if (items.isEmpty()) {
            throw new IllegalStateException("No service for registry '" + this.registry.getMetadata().getName() + "'");
        }
        return (Service)items.get(0);
    }

    protected String getRegistryAddress() {
        Service s = this.getRegistryService();
        return "http://" + s.getMetadata().getName() + "." + this.project + ".svc.cluster.local:8080";
    }

    @Override
    public String getRegistryApiAddress() {
        return this.getRegistryAddress() + "/apis/registry/v2";
    }

    @Override
    public String getPublicRegistryApiAddress() {
        return "http://" + this.getPublicRegistryAddress() + "/apis/registry/v2";
    }

    @Override
    public void waitForRegistry() throws InterruptedException {
        LOGGER.info("Waiting for deployments of registry '" + this.name + "' in '" + this.project + "'");
        Awaitility.await().atMost(WaitConditions.scaled(1L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> !this.getRegistryDeployments(this.name).isEmpty());
        Deployment deployment = this.getRegistryDeployments(this.name).get(0);
        ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(deployment.getMetadata().getName())).waitUntilCondition(WaitConditions::deploymentAvailableCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
        this.registry = (ApicurioRegistry)((Resource)this.registryOperation().withName(this.name)).get();
    }

    private List<Deployment> getRegistryDeployments(String name) {
        return ((DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withLabel("app", name)).list()).getItems();
    }

    @Override
    public boolean undeploy() {
        return this.registryOperation().delete((Object[])new ApicurioRegistry[]{this.registry});
    }
}

