/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb;

import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.databases.AbstractOcpDatabaseDeployer;
import io.debezium.testing.system.tools.databases.mongodb.OcpMongoShardedController;
import io.debezium.testing.system.tools.databases.mongodb.builders.OcpShardModelFactory;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.openshift.client.OpenShiftClient;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpMongoShardedDeployer
extends AbstractOcpDatabaseDeployer<OcpMongoShardedController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoShardedDeployer.class);
    private final Deployment mongosDeployment;
    private final Deployment configDeployment;

    private OcpMongoShardedDeployer(String project, Deployment mongosDeployment, Deployment configDeployment, List<Service> services, OpenShiftClient ocp) {
        super(project, null, services, ocp);
        this.mongosDeployment = mongosDeployment;
        this.configDeployment = configDeployment;
    }

    @Override
    public OcpMongoShardedController deploy() {
        if (this.pullSecret != null) {
            LOGGER.info("Deploying pull secrets");
            ((NonNamespaceOperation)this.ocp.secrets().inNamespace(this.project)).createOrReplace((Object[])new Secret[]{this.pullSecret});
            this.ocpUtils.linkPullSecret(this.project, "default", this.pullSecret);
        }
        LOGGER.info("Deploying mongo config server");
        ((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.configDeployment});
        this.ocpUtils.waitForPods(this.project, this.configDeployment.getMetadata().getLabels());
        this.ocpUtils.createService(this.project, this.configDeployment.getMetadata().getName(), "db", 27019, this.configDeployment.getMetadata().getLabels(), this.configDeployment.getMetadata().getLabels());
        LOGGER.info("Deploying mongos router");
        this.deployment = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{this.mongosDeployment});
        this.ocpUtils.createService(this.project, this.mongosDeployment.getMetadata().getName(), "db", 27017, this.mongosDeployment.getMetadata().getLabels(), this.mongosDeployment.getMetadata().getLabels());
        LOGGER.info("Deploying mongo shards");
        List shardRange = IntStream.rangeClosed(1, 3).boxed().collect(Collectors.toList());
        List replicaRange = IntStream.rangeClosed(1, 2).boxed().collect(Collectors.toList());
        shardRange.parallelStream().forEach(shardNum -> replicaRange.parallelStream().forEach(replicaNum -> {
            Deployment deployment1 = (Deployment)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).createOrReplace((Object[])new Deployment[]{OcpShardModelFactory.shardDeployment(shardNum, replicaNum)});
            this.services.add((Service)((NonNamespaceOperation)this.ocp.services().inNamespace(this.project)).createOrReplace((Object[])new Service[]{OcpShardModelFactory.shardService(shardNum, replicaNum)}));
            this.ocpUtils.waitForPods(this.project, deployment1.getMetadata().getLabels());
        }));
        LOGGER.info("Database deployed successfully");
        return this.getController(this.deployment, this.services, this.ocp);
    }

    @Override
    protected OcpMongoShardedController getController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        return new OcpMongoShardedController(deployment, services, ocp);
    }

    public static class Deployer
    extends AbstractOcpDatabaseDeployer.DatabaseBuilder<Deployer, OcpMongoShardedDeployer> {
        private Deployment mongosDeployment;
        private Deployment configDeployment;

        @Override
        public OcpMongoShardedDeployer build() {
            return new OcpMongoShardedDeployer(this.project, this.mongosDeployment, this.configDeployment, this.services, this.ocpClient);
        }

        public Deployer withMongosDeployment(String deployment) {
            this.mongosDeployment = YAML.fromResource(deployment, Deployment.class);
            return (Deployer)this.self();
        }

        public Deployer withConfigDeployment(String deployment) {
            this.configDeployment = YAML.fromResource(deployment, Deployment.class);
            return (Deployer)this.self();
        }
    }
}

