/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.databases.Commands;
import io.debezium.testing.system.tools.databases.DatabaseClient;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDatabaseClient
implements DatabaseClient<Connection, SQLException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlDatabaseClient.class);
    private final String url;
    private final String username;
    private final String password;

    public SqlDatabaseClient(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    private boolean doExecute(Commands<Connection, SQLException> commands) throws SQLException {
        try (Connection con = this.connect();){
            commands.execute(con);
        }
        return true;
    }

    @Override
    public void execute(Commands<Connection, SQLException> commands) throws SQLException {
        Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).ignoreExceptions().until(() -> this.doExecute(commands));
    }

    public void execute(String database, Commands<Connection, SQLException> commands) throws SQLException {
        Commands withDatabase = con -> con.setCatalog(database);
        this.execute((Connection con) -> withDatabase.andThen(commands).execute((Connection)con));
    }

    public void execute(String database, String command) throws SQLException {
        LOGGER.info("Running SQL Command [" + database + "]: " + command);
        this.execute(database, (Connection con) -> {
            try (Statement stmt = con.createStatement();){
                stmt.execute(command);
            }
        });
    }

    public void execute(String command) throws SQLException {
        LOGGER.info("Running SQL Command: " + command);
        this.execute((Connection con) -> {
            try (Statement stmt = con.createStatement();){
                stmt.execute(command);
            }
        });
    }

    public <T> T executeQuery(String database, String command, Function<ResultSet, T> resultSetProcessor) throws SQLException {
        LOGGER.info("Running SQL Query: " + command);
        try (Connection con = this.connect();){
            T t;
            block12: {
                con.setCatalog(database);
                Statement stmt = con.createStatement();
                try {
                    ResultSet rs = stmt.executeQuery(command);
                    t = resultSetProcessor.apply(rs);
                    if (stmt == null) break block12;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return t;
        }
    }

    public Connection connect() throws SQLException {
        LOGGER.info("Connecting to " + this.url);
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public Connection connectWithRetries() {
        return (Connection)Awaitility.await().atMost(WaitConditions.scaled(2L), TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).ignoreExceptions().until(this::connect, Objects::nonNull);
    }
}

