/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb;

import io.debezium.testing.system.TestUtils;
import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.AbstractOcpDatabaseController;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpMongoShardedController
extends AbstractOcpDatabaseController<MongoDatabaseClient>
implements MongoDatabaseController {
    public static final String INIT_MONGOS_SCRIPT_LOCATION = "/database-resources/mongodb/sharded/init-mongos.js";
    public static final String CREATE_DBZ_USER_SCRIPT_LOCATION = "/database-resources/mongodb/sharded/create-dbz-user.js";
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpMongoShardedController.class);

    public OcpMongoShardedController(Deployment deployment, List<Service> services, OpenShiftClient ocp) {
        super(deployment, services, ocp);
    }

    @Override
    public String getPublicDatabaseUrl() {
        return "mongodb://" + this.getPublicDatabaseHostname() + ":" + this.getPublicDatabasePort();
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password) {
        return this.getDatabaseClient(username, password, "admin");
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password, String authSource) {
        return new MongoDatabaseClient(this.getPublicDatabaseUrl(), username, password, authSource);
    }

    @Override
    public void reload() throws InterruptedException {
        LOGGER.info("Restarting all mongo shards and mongos");
        List deployments = ((DeploymentList)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).list()).getItems().stream().filter(d -> d.getMetadata().getName().equals("mongo-config") || d.getMetadata().getName().equals("mongo-mongos") || d.getMetadata().getName().startsWith("mongo-shard")).collect(Collectors.toList());
        ((Stream)deployments.stream().parallel()).forEach(mongoComponent -> {
            Deployment deployment1 = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(mongoComponent.getMetadata().getName())).get();
            this.ocpUtils.scaleDeploymentToZero(deployment1);
            ((RollableScalableResource)((NonNamespaceOperation)this.ocp.apps().deployments().inNamespace(this.project)).withName(deployment1.getMetadata().getName())).scale(1);
        });
    }

    public void executeCommandOnComponent(String componentName, String ... commands) throws InterruptedException {
        Optional<Deployment> maybeDeployment = this.ocpUtils.deploymentsWithPrefix(this.project, componentName);
        if (maybeDeployment.isEmpty()) {
            throw new IllegalStateException("Deployment of " + componentName + " missing");
        }
        this.executeCommand(maybeDeployment.get(), commands);
    }

    @Override
    public void initialize() throws InterruptedException {
        LOGGER.info("Initializing replica-set");
        this.executeCommandOnComponent("mongo-config", "mongosh", "localhost:27019", "--eval", "rs.initiate({ _id: \"cfgrs\", configsvr: true, members: [{ _id : 0, host : \"mongo-config." + ConfigProperties.OCP_PROJECT_MONGO + ".svc.cluster.local:27019\" }]})");
        this.uploadAndExecuteMongoScript(CREATE_DBZ_USER_SCRIPT_LOCATION, "mongo-config", 27019);
        LOGGER.info("Initializing all the shards");
        List shardRange = IntStream.rangeClosed(1, 3).boxed().collect(Collectors.toList());
        shardRange.parallelStream().forEach(s -> {
            try {
                this.executeCommandOnComponent("mongo-shard" + s + "r1", this.getShardInitCommand((int)s));
                this.uploadAndExecuteMongoScript(CREATE_DBZ_USER_SCRIPT_LOCATION, "mongo-shard" + s + "r1", 27018);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        LOGGER.info("Adding shards to mongos");
        this.addShard(1, "ONE", 1000, 1003);
        this.addShard(2, "TWO", 1003, 1004);
        this.uploadAndExecuteMongoScript(INIT_MONGOS_SCRIPT_LOCATION, "mongo-mongos", 27017);
    }

    public void addShard(int shardNumber, String zoneName, int rangeStart, int rangeEnd) throws InterruptedException {
        List replicaRange = IntStream.rangeClosed(1, 2).boxed().collect(Collectors.toList());
        this.executeCommandOnComponent("mongo-mongos", "mongosh", "localhost:27017", "--eval", "sh.addShard(\"shard" + shardNumber + "rs/" + replicaRange.stream().map(r -> this.getShardReplicaServiceName(shardNumber, (int)r)).collect(Collectors.joining(",")) + "\");sh.addShardToZone(\"shard" + shardNumber + "rs\", \"" + zoneName + "\");sh.updateZoneKeyRange(\"inventory.customers\",{ _id : " + rangeStart + " },{ _id : " + rangeEnd + " },\"" + zoneName + "\");");
    }

    public void removeShard(int shardNumber, int rangeStart, int rangeEnd) throws InterruptedException {
        this.executeCommandOnComponent("mongo-mongos", "mongosh", "localhost:27017", "--eval", "sh.removeRangeFromZone(\"inventory.customers\",{ _id : " + rangeStart + " },{ _id : " + rangeEnd + " });db.adminCommand({removeShard:\"shard" + shardNumber + "rs\"})");
    }

    private void uploadAndExecuteMongoScript(String scriptLocation, String component, int port) throws InterruptedException {
        Path scriptPath;
        try {
            scriptPath = Paths.get(Objects.requireNonNull(this.getClass().getResource(scriptLocation)).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String podName = this.ocpUtils.podsWithLabels(this.project, Map.of("deployment", component)).get(0).getMetadata().getName();
        PodResource podResource = (PodResource)((NonNamespaceOperation)this.ocp.pods().inNamespace(this.project)).withName(podName);
        String containerPath = "/opt/" + scriptPath.getFileName().toString() + TestUtils.getUniqueId() + ".js";
        ((CopyOrReadable)podResource.file(containerPath)).upload(scriptPath);
        this.executeCommandOnComponent(component, "mongosh", "localhost:" + port, "-f", containerPath);
    }

    private String[] getShardInitCommand(int shardNum) {
        List replicaRange = IntStream.rangeClosed(1, 2).boxed().collect(Collectors.toList());
        return new String[]{"mongosh", "localhost:27018", "--eval", "rs.initiate({ _id: \"shard" + shardNum + "rs\", members: [" + replicaRange.stream().map(replicaNum -> "{_id : " + (replicaNum - 1) + ", host : \"" + this.getShardReplicaServiceName(shardNum, (int)replicaNum) + "\" }").collect(Collectors.joining(",")) + "]});let isPrimary = false;\nlet count = 0;\nwhile(isPrimary == false && count < 30) {\n  const rplStatus = db.adminCommand({ replSetGetStatus : 1 });\n  isPrimary = rplStatus.members[0].stateStr === \"PRIMARY\";\n  print(\"is primary result: \", isPrimary);\n  count = count + 1;\n  sleep(1000);\n}"};
    }

    private String getShardReplicaServiceName(int shardNum, int replicaNum) {
        return "mongo-shard" + shardNum + "r" + replicaNum + "." + ConfigProperties.OCP_PROJECT_MONGO + ".svc.cluster.local:27018";
    }
}

