/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb;

import io.debezium.testing.system.tools.ConfigProperties;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseClient;
import io.debezium.testing.system.tools.databases.mongodb.MongoDatabaseController;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.utility.MountableFile;

public class DockerMongoController
implements MongoDatabaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerMongoController.class);
    private static final String DB_INIT_SCRIPT_PATH_CONTAINER = "/usr/local/bin/init-inventory.js";
    public static final int MONGODB_INTERNAL_PORT = 27017;
    private static final MountableFile INIT_SCRIPT_RESOURCE = MountableFile.forClasspathResource((String)"/database-resources/mongodb/docker/init-inventory.js");
    private final MongoDbReplicaSet mongo;

    public DockerMongoController(MongoDbReplicaSet mongo) {
        this.mongo = mongo;
    }

    @Override
    public String getDatabaseHostname() {
        throw new UnsupportedOperationException("MongoDB docker controller doesn't support direct access to hostnames");
    }

    @Override
    public int getDatabasePort() {
        return 27017;
    }

    @Override
    public String getPublicDatabaseHostname() {
        return this.getDatabaseHostname();
    }

    @Override
    public int getPublicDatabasePort() {
        throw new UnsupportedOperationException("MongoDB docker controller doesn't support direct access to ports");
    }

    @Override
    public String getPublicDatabaseUrl() {
        return this.mongo.getNoAuthConnectionString();
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password) {
        return this.getDatabaseClient(username, password, "admin");
    }

    @Override
    public void reload() {
        this.mongo.stop();
        this.mongo.start();
    }

    @Override
    public MongoDatabaseClient getDatabaseClient(String username, String password, String authSource) {
        return new MongoDatabaseClient(this.getPublicDatabaseUrl(), username, password, authSource);
    }

    @Override
    public void initialize() throws InterruptedException {
        LOGGER.info("Waiting until database is initialized");
        this.mongo.execMongoScript(INIT_SCRIPT_RESOURCE, DB_INIT_SCRIPT_PATH_CONTAINER);
        this.mongo.createUser(ConfigProperties.DATABASE_MONGO_DBZ_USERNAME, ConfigProperties.DATABASE_MONGO_DBZ_PASSWORD, "admin", new String[]{"root"});
    }
}

