/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases.mongodb.builders;

import io.debezium.testing.system.tools.ConfigProperties;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSource;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.TCPSocketActionBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategyBuilder;
import java.util.Map;

public class OcpShardModelFactory {
    public static final String ROLE = "shard";

    public static Deployment shardDeployment(int shardNum, int replicaNum) {
        String name = OcpShardModelFactory.getShardName(shardNum, replicaNum);
        ObjectMeta metaData = ((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).withLabels(Map.of("app", "mongo", "deployment", name, "role", ROLE))).build();
        DeploymentBuilder builder = (DeploymentBuilder)((DeploymentBuilder)((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withKind("Deployment")).withApiVersion("apps/v1")).withMetadata(metaData)).withSpec(((DeploymentSpecBuilder)((DeploymentSpecBuilder)((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withReplicas(Integer.valueOf(1))).withStrategy(((DeploymentStrategyBuilder)new DeploymentStrategyBuilder().withType("Recreate")).build())).withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(metaData.getLabels())).build())).withTemplate(((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(metaData.getLabels())).build())).withSpec(((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("volume-" + name)).withEmptyDir(new EmptyDirVolumeSource())).build()})).withContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("mongo")).withPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withProtocol("TCP")).withContainerPort(Integer.valueOf(27018))).build()})).withImagePullPolicy("Always")).withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("volume-" + name)).withMountPath("/data/db")).build()})).withLivenessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withInitialDelaySeconds(Integer.valueOf(10))).withTcpSocket(((TCPSocketActionBuilder)new TCPSocketActionBuilder().withPort(new IntOrString(Integer.valueOf(27018)))).build())).withTimeoutSeconds(Integer.valueOf(20))).build())).withTerminationMessagePolicy("File")).withTerminationMessagePath("/dev/termination-log")).withImage(ConfigProperties.DOCKER_IMAGE_MONGO_SHARDED)).withCommand(new String[]{"mongod", "--shardsvr", "--replSet", ROLE + shardNum + "rs", "--dbpath", "/data/db", "--bind_ip_all"})).build()})).build())).build())).build());
        return builder.build();
    }

    public static Service shardService(int shardNum, int replicaNum) {
        String name = OcpShardModelFactory.getShardName(shardNum, replicaNum);
        return ((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().withKind("Service")).withApiVersion("v1")).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(name)).build())).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withSelector(Map.of("app", "mongo", "deployment", name, "role", ROLE))).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("db")).withPort(Integer.valueOf(27018))).withTargetPort(new IntOrString(Integer.valueOf(27018)))).build()})).build())).build();
    }

    private static String getShardName(int shardNum, int replicaNum) {
        return "mongo-shard" + shardNum + "r" + replicaNum;
    }
}

