/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.registry;

import io.apicurio.registry.operator.api.model.ApicurioRegistry;
import io.apicurio.registry.operator.api.model.ApicurioRegistryList;
import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.registry.OcpApicurioController;
import io.debezium.testing.system.tools.registry.builders.FabricApicurioBuilder;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpApicurioDeployer
extends AbstractOcpDeployer<OcpApicurioController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpApicurioDeployer.class);
    private final FabricApicurioBuilder fabricBuilder;

    public OcpApicurioDeployer(String project, FabricApicurioBuilder fabricBuilder, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.fabricBuilder = fabricBuilder;
    }

    @Override
    public OcpApicurioController deploy() throws InterruptedException {
        LOGGER.info("Deploying Apicurio Registry to '" + this.project + "'");
        ApicurioRegistry registry = this.fabricBuilder.build();
        registry = (ApicurioRegistry)this.registryOperation().createOrReplace((Object[])new ApicurioRegistry[]{registry});
        OcpApicurioController controller = this.getController(registry);
        controller.waitForRegistry();
        return controller;
    }

    protected OcpApicurioController getController(ApicurioRegistry registry) {
        return new OcpApicurioController(registry, this.ocp, this.http);
    }

    protected NonNamespaceOperation<ApicurioRegistry, ApicurioRegistryList, Resource<ApicurioRegistry>> registryOperation() {
        return (NonNamespaceOperation)this.ocp.resources(ApicurioRegistry.class, ApicurioRegistryList.class).inNamespace(this.project);
    }
}

