/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.builders;

import io.debezium.testing.system.tools.fabric8.FabricBuilderWrapper;
import io.debezium.testing.system.tools.fabric8.OperatorSubscriptionBuilder;
import io.debezium.testing.system.tools.operatorutil.OpenshiftOperatorEnum;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionSpecBuilder;

public class StrimziSubscriptionBuilder
extends FabricBuilderWrapper<StrimziSubscriptionBuilder, SubscriptionBuilder, Subscription>
implements OperatorSubscriptionBuilder {
    private static final String STRIMZI_OPERATOR_NAME = "strimzi-kafka-operator";
    private static final String AMQ_STREAMS_OPERATOR_NAME = "amq-streams";

    protected StrimziSubscriptionBuilder(SubscriptionBuilder builder) {
        super(builder);
    }

    public static StrimziSubscriptionBuilder base() {
        SubscriptionBuilder builder = (SubscriptionBuilder)((SubscriptionBuilder)new SubscriptionBuilder().withKind("Subscription")).withApiVersion("operators.coreos.com/v1alpha1");
        return new StrimziSubscriptionBuilder(builder);
    }

    @Override
    public StrimziSubscriptionBuilder withCommunityConfig() {
        ((SubscriptionBuilder)((SubscriptionBuilder)((SubscriptionBuilder)this.builder).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(OpenshiftOperatorEnum.STRIMZI.getDeploymentNamePrefix())).build())).withSpec(((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)new SubscriptionSpecBuilder().withName(STRIMZI_OPERATOR_NAME)).withSource("community-operators")).withSourceNamespace("openshift-marketplace")).withInstallPlanApproval("Automatic")).build())).build();
        return (StrimziSubscriptionBuilder)this.self();
    }

    @Override
    public StrimziSubscriptionBuilder withProductConfig() {
        ((SubscriptionBuilder)((SubscriptionBuilder)this.builder).withMetadata(((ObjectMetaBuilder)new ObjectMetaBuilder().withName(OpenshiftOperatorEnum.STRIMZI.getDeploymentNamePrefix())).build())).withSpec(((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)((SubscriptionSpecBuilder)new SubscriptionSpecBuilder().withName(AMQ_STREAMS_OPERATOR_NAME)).withSource("redhat-operators")).withSourceNamespace("openshift-marketplace")).withInstallPlanApproval("Automatic")).build());
        return (StrimziSubscriptionBuilder)this.self();
    }

    @Override
    public StrimziSubscriptionBuilder withNamespace(String namespace) {
        ((SubscriptionFluent.MetadataNested)((SubscriptionBuilder)this.builder).editMetadata().withNamespace(namespace)).endMetadata();
        return (StrimziSubscriptionBuilder)this.self();
    }

    @Override
    public StrimziSubscriptionBuilder withChannel(String channel) {
        ((SubscriptionFluent.SpecNested)((SubscriptionBuilder)this.builder).editSpec().withChannel(channel)).endSpec();
        return (StrimziSubscriptionBuilder)this.self();
    }

    @Override
    public Subscription build() {
        return ((SubscriptionBuilder)this.builder).build();
    }
}

