/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka.connectors;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.kafka.ConnectorConfigBuilder;
import io.debezium.testing.system.tools.kafka.connectors.ConnectorDeployer;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaConnectorList;
import io.strimzi.api.kafka.model.KafkaConnect;
import io.strimzi.api.kafka.model.KafkaConnector;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomResourceConnectorDeployer
implements ConnectorDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomResourceConnectorDeployer.class);
    private final KafkaConnect kafkaConnect;
    private final String project;
    private final OpenShiftClient ocp;

    public CustomResourceConnectorDeployer(KafkaConnect kafkaConnect, OpenShiftClient ocp) {
        this.kafkaConnect = kafkaConnect;
        this.project = kafkaConnect.getMetadata().getNamespace();
        this.ocp = ocp;
    }

    @Override
    public void deploy(ConnectorConfigBuilder config) {
        LOGGER.info("Deploying connector CR for connector " + config.getConnectorName());
        KafkaConnector connector = config.getCustomResource();
        connector.getMetadata().getLabels().put("strimzi.io/cluster", this.kafkaConnect.getMetadata().getName());
        this.kafkaConnectorOperation().createOrReplace((Object[])new KafkaConnector[]{connector});
        this.waitForKafkaConnector(config);
    }

    @Override
    public void undeploy(String name) {
        LOGGER.info("Undeploying kafka connector " + name);
        ((Resource)this.kafkaConnectorOperation().withName(name)).delete();
        Awaitility.await().atMost(1L, TimeUnit.MINUTES).pollInterval(5L, TimeUnit.SECONDS).until(() -> ((Resource)this.kafkaConnectorOperation().withName(name)).get() == null);
    }

    private NonNamespaceOperation<KafkaConnector, KafkaConnectorList, Resource<KafkaConnector>> kafkaConnectorOperation() {
        return (NonNamespaceOperation)Crds.kafkaConnectorOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    private void waitForKafkaConnector(ConnectorConfigBuilder config) {
        this.waitForKafkaConnector(config.getConnectorName());
    }

    private void waitForKafkaConnector(String name) {
        LOGGER.info("Waiting for connector '" + name + "' to become ready.");
        ((Resource)this.kafkaConnectorOperation().withName(name)).waitUntilCondition(WaitConditions::kafkaReadyCondition, 5L, TimeUnit.MINUTES);
        LOGGER.info("Connector '" + name + "' is ready.");
    }
}

