/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.strimzi.api.kafka.model.KafkaConnector;
import io.strimzi.api.kafka.model.KafkaConnectorBuilder;
import io.strimzi.api.kafka.model.KafkaConnectorFluent;
import java.util.HashMap;
import java.util.Map;

public class ConnectorConfigBuilder {
    private final Map<String, Object> config;
    private final ObjectMapper mapper = new ObjectMapper();
    private final String connectorName;

    public ConnectorConfigBuilder(String connectorName) {
        this.config = new HashMap<String, Object>();
        this.connectorName = connectorName;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getDbServerName() {
        return this.connectorName.replaceAll("-", "_");
    }

    public ConnectorConfigBuilder put(String key, Object value) {
        this.config.put(key, value);
        return this;
    }

    public Map<String, Object> get() {
        return this.config;
    }

    public String getAsString(String key) {
        return String.valueOf(this.config.get(key));
    }

    public ConnectorConfigBuilder addApicurioAvroSupport(String apicurioUrl) {
        this.config.put("key.converter", "io.apicurio.registry.utils.converter.AvroConverter");
        this.config.put("key.converter.apicurio.registry.url", apicurioUrl);
        this.config.put("key.converter.apicurio.registry.auto-register", true);
        this.config.put("key.converter.apicurio.registry.find-latest", true);
        this.config.put("value.converter", "io.apicurio.registry.utils.converter.AvroConverter");
        this.config.put("value.converter.apicurio.registry.url", apicurioUrl);
        this.config.put("value.converter.apicurio.registry.auto-register", true);
        this.config.put("value.converter.apicurio.registry.find-latest", true);
        this.config.put("schema.name.adjustment.mode", "avro");
        return this;
    }

    public ConnectorConfigBuilder addContentBasedRouter(String expression, String topicNamePattern) {
        this.config.put("transforms", "route");
        this.config.put("transforms.route.type", "io.debezium.transforms.ContentBasedRouter");
        this.config.put("transforms.route.language", "jsr223.groovy");
        this.config.put("transforms.route.topic.expression", expression);
        this.config.put("transforms.route.predicate", "TopicPredicate");
        this.config.put("predicates", "TopicPredicate");
        this.config.put("predicates.TopicPredicate.type", "org.apache.kafka.connect.transforms.predicates.TopicNameMatches");
        this.config.put("predicates.TopicPredicate.pattern", topicNamePattern);
        return this;
    }

    public ConnectorConfigBuilder addOperationRouter(String op, String targetTopicName, String sourceTopicPattern) {
        return this.addContentBasedRouter("value.op == '" + op + "' ? '" + targetTopicName + "' : null", sourceTopicPattern);
    }

    public ConnectorConfigBuilder addOperationRouterForTable(String op, String tableName) {
        String serverName = this.getDbServerName();
        String targetTopicName = serverName + "." + op + "." + tableName;
        return this.addOperationRouter(op, targetTopicName, serverName + ".*\\." + tableName);
    }

    public String getJsonString() {
        try {
            return this.mapper.writeValueAsString(this.config);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to convert connector config to JSON String");
        }
    }

    public KafkaConnector getCustomResource() {
        HashMap<String, Object> crConfig = new HashMap<String, Object>(this.config);
        KafkaConnectorBuilder connectorBuilder = new KafkaConnectorBuilder();
        return ((KafkaConnectorBuilder)((KafkaConnectorFluent.SpecNested)((KafkaConnectorFluent.SpecNested)((KafkaConnectorFluent.SpecNested)((KafkaConnectorBuilder)((KafkaConnectorFluent.MetadataNested)((KafkaConnectorFluent.MetadataNested)connectorBuilder.withNewMetadata().withLabels(new HashMap())).withName(this.connectorName)).endMetadata()).withNewSpec().withClassName((String)crConfig.remove("connector.class"))).withTasksMax((Integer)crConfig.remove("task.max"))).withConfig(crConfig)).endSpec()).build();
    }
}

