/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.debezium.testing.system.tools.kafka.builders.kafka.StrimziKafkaBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.Kafka;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcpKafkaDeployer
extends AbstractOcpDeployer<OcpKafkaController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaDeployer.class);
    private final StrimziKafkaBuilder strimziBuilder;
    private final StrimziOperatorController operatorController;

    private OcpKafkaDeployer(String project, StrimziKafkaBuilder strimziBuilder, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.strimziBuilder = strimziBuilder;
        this.operatorController = operatorController;
    }

    @Override
    public OcpKafkaController deploy() throws InterruptedException {
        LOGGER.info("Deploying Kafka Cluster");
        Kafka kafka = (Kafka)this.kafkaOperation().createOrReplace((Object[])new Kafka[]{this.strimziBuilder.build()});
        OcpKafkaController controller = new OcpKafkaController(kafka, this.operatorController, this.ocp);
        controller.waitForCluster();
        return controller;
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpKafkaDeployer> {
        private String project;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private StrimziOperatorController operatorController;
        private final StrimziKafkaBuilder strimziBuilder;

        public Builder(StrimziKafkaBuilder strimziBuilder) {
            this.strimziBuilder = strimziBuilder;
        }

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withOperatorController(StrimziOperatorController operatorController) {
            this.operatorController = operatorController;
            operatorController.getPullSecretName().ifPresent(this.strimziBuilder::withPullSecret);
            return this;
        }

        @Override
        public OcpKafkaDeployer build() {
            return new OcpKafkaDeployer(this.project, this.strimziBuilder, this.operatorController, this.ocpClient, this.httpClient);
        }
    }
}

