/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.AbstractOcpDeployer;
import io.debezium.testing.system.tools.Deployer;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.OcpKafkaController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.model.EntityOperatorSpecFluent;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.ZookeeperClusterSpecFluent;
import io.strimzi.api.kafka.model.template.PodTemplate;
import io.strimzi.api.kafka.model.template.PodTemplateBuilder;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcpKafkaDeployer
extends AbstractOcpDeployer<OcpKafkaController> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaDeployer.class);
    private final String yamlPath;
    private final String pullSecretName;
    private final StrimziOperatorController operatorController;

    private OcpKafkaDeployer(String project, String yamlPath, StrimziOperatorController operatorController, OpenShiftClient ocp, OkHttpClient http) {
        super(project, ocp, http);
        this.yamlPath = yamlPath;
        this.operatorController = operatorController;
        this.pullSecretName = this.operatorController.getPullSecretName();
    }

    @Override
    public OcpKafkaController deploy() throws InterruptedException {
        LOGGER.info("Deploying Kafka from " + this.yamlPath);
        Kafka kafka = YAML.fromResource(this.yamlPath, Kafka.class);
        KafkaBuilder builder = new KafkaBuilder(kafka);
        if (this.pullSecretName != null) {
            this.configurePullSecret(builder);
        }
        kafka = (Kafka)this.kafkaOperation().createOrReplace((Object[])new Kafka[]{builder.build()});
        OcpKafkaController controller = new OcpKafkaController(kafka, this.operatorController, this.ocp);
        controller.waitForCluster();
        return controller;
    }

    public void configurePullSecret(KafkaBuilder builder) {
        PodTemplate podTemplate = ((PodTemplateBuilder)new PodTemplateBuilder().addNewImagePullSecret(this.pullSecretName)).build();
        ((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((EntityOperatorSpecFluent.TemplateNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((ZookeeperClusterSpecFluent.TemplateNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.TemplateNested)builder.editSpec().editKafka().withNewTemplate().withPod(podTemplate)).endTemplate()).endKafka()).editZookeeper().withNewTemplate().withPod(podTemplate)).endTemplate()).endZookeeper()).editEntityOperator().withNewTemplate().withPod(podTemplate)).endTemplate()).endEntityOperator()).endSpec();
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    public static class Builder
    implements Deployer.Builder<Builder, OcpKafkaDeployer> {
        private String project;
        private String yamlPath;
        private OpenShiftClient ocpClient;
        private OkHttpClient httpClient;
        private StrimziOperatorController operatorController;

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withOcpClient(OpenShiftClient ocpClient) {
            this.ocpClient = ocpClient;
            return this;
        }

        public Builder withHttpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder withYamlPath(String yamlPath) {
            this.yamlPath = yamlPath;
            return this;
        }

        public Builder withOperatorController(StrimziOperatorController operatorController) {
            this.operatorController = operatorController;
            return this;
        }

        @Override
        public OcpKafkaDeployer build() {
            return new OcpKafkaDeployer(this.project, this.yamlPath, this.operatorController, this.ocpClient, this.httpClient);
        }
    }
}

