/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.kafka;

import io.debezium.testing.system.tools.WaitConditions;
import io.debezium.testing.system.tools.YAML;
import io.debezium.testing.system.tools.kafka.KafkaController;
import io.debezium.testing.system.tools.kafka.StrimziOperatorController;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.strimzi.api.kafka.Crds;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.status.ListenerAddress;
import io.strimzi.api.kafka.model.status.ListenerStatus;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcpKafkaController
implements KafkaController {
    private static final Logger LOGGER = LoggerFactory.getLogger(OcpKafkaController.class);
    private final OpenShiftClient ocp;
    private final String project;
    private final String name;
    private final StrimziOperatorController operatorController;
    private Kafka kafka;

    public OcpKafkaController(Kafka kafka, StrimziOperatorController operatorController, OpenShiftClient ocp) {
        this.kafka = kafka;
        this.name = kafka.getMetadata().getName();
        this.ocp = ocp;
        this.project = kafka.getMetadata().getNamespace();
        this.operatorController = operatorController;
    }

    @Override
    public String getPublicBootstrapAddress() {
        List listeners = this.kafka.getStatus().getListeners();
        ListenerStatus listener = listeners.stream().filter(l -> l.getType().equalsIgnoreCase("external")).findAny().orElseThrow(() -> new IllegalStateException("No external listener found for Kafka cluster " + this.kafka.getMetadata().getName()));
        ListenerAddress address = (ListenerAddress)listener.getAddresses().get(0);
        return address.getHost() + ":" + address.getPort();
    }

    @Override
    public String getBootstrapAddress() {
        return this.name + "-kafka-bootstrap." + this.project + ".svc.cluster.local:9092";
    }

    public KafkaTopic deployTopic(String yamlPath) throws InterruptedException {
        LOGGER.info("Deploying Kafka topic from " + yamlPath);
        KafkaTopic topic = (KafkaTopic)this.topicOperation().createOrReplace((Object[])new KafkaTopic[]{YAML.fromResource(yamlPath, KafkaTopic.class)});
        return this.waitForKafkaTopic(topic.getMetadata().getName());
    }

    @Override
    public boolean undeploy() {
        return Crds.kafkaOperation((KubernetesClient)this.ocp).delete((Object[])new Kafka[]{this.kafka});
    }

    @Override
    public void waitForCluster() throws InterruptedException {
        LOGGER.info("Waiting for Kafka cluster '" + this.name + "'");
        this.kafka = (Kafka)((Resource)this.kafkaOperation().withName(this.name)).waitUntilCondition(WaitConditions::kafkaReadyCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
    }

    private KafkaTopic waitForKafkaTopic(String name) throws InterruptedException {
        return (KafkaTopic)((Resource)this.topicOperation().withName(name)).waitUntilCondition(WaitConditions::kafkaReadyCondition, WaitConditions.scaled(5L), TimeUnit.MINUTES);
    }

    private NonNamespaceOperation<KafkaTopic, KafkaTopicList, Resource<KafkaTopic>> topicOperation() {
        return (NonNamespaceOperation)Crds.topicOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }

    private NonNamespaceOperation<Kafka, KafkaList, Resource<Kafka>> kafkaOperation() {
        return (NonNamespaceOperation)Crds.kafkaOperation((KubernetesClient)this.ocp).inNamespace(this.project);
    }
}

