/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.testing.system.tools.databases;

import io.fabric8.kubernetes.client.dsl.ExecListener;
import java.util.concurrent.CountDownLatch;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInitListener
implements ExecListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseInitListener.class);
    private final String name;
    private final CountDownLatch latch;

    public DatabaseInitListener(String name, CountDownLatch latch) {
        this.latch = latch;
        this.name = name;
    }

    public void onOpen(Response response) {
        LOGGER.info("Initializing  database '" + this.name + "'");
    }

    public void onFailure(Throwable t, Response response) {
        LOGGER.error("Error initializing database '" + this.name + "'");
        LOGGER.error(response.message());
        this.latch.countDown();
    }

    public void onClose(int code, String reason) {
        LOGGER.info("Init executor close: [" + code + "] " + reason);
        this.latch.countDown();
    }
}

