/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.redis;

import io.debezium.storage.redis.RedisClient;
import io.debezium.util.DelayStrategy;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitReplicasRedisClient
implements RedisClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitReplicasRedisClient.class);
    private final RedisClient delegate;
    private final int replicas;
    private final long timeout;
    private final boolean retry;
    private final long delay;

    public WaitReplicasRedisClient(RedisClient delegate, int replicas, long timeout, boolean retry, long delay) {
        this.delegate = delegate;
        this.replicas = replicas;
        this.timeout = timeout;
        this.retry = retry;
        this.delay = delay;
    }

    @Override
    public void disconnect() {
        this.delegate.disconnect();
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public String xadd(String key, Map<String, String> hash) {
        return this.waitResult(() -> this.delegate.xadd(key, hash));
    }

    @Override
    public List<String> xadd(List<AbstractMap.SimpleEntry<String, Map<String, String>>> hashes) {
        return this.waitResult(() -> this.delegate.xadd(hashes));
    }

    @Override
    public List<Map<String, String>> xrange(String key) {
        return this.delegate.xrange(key);
    }

    @Override
    public long xlen(String key) {
        return this.delegate.xlen(key);
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.delegate.hgetAll(key);
    }

    @Override
    public long hset(byte[] key, byte[] field, byte[] value) {
        return this.waitResult(() -> this.delegate.hset(key, field, value));
    }

    @Override
    public long waitReplicas(int replicas, long timeout) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "WaitReplicaRedisClient [delegate=" + this.delegate + ", replicas=" + this.replicas + ", timeout=" + this.timeout + ", retry=" + this.retry + ", delay=" + this.delay + "]";
    }

    private <R> R waitResult(Supplier<R> supplier) {
        R result;
        block2: {
            DelayStrategy delayStrategy = null;
            while (true) {
                result = supplier.get();
                long reachedReplicas = this.delegate.waitReplicas(this.replicas, this.timeout);
                if (reachedReplicas == (long)this.replicas) break block2;
                if (!this.retry) break;
                LOGGER.error("Failed to update {} replica(s) in {} millis. Retrying in {} millis...", new Object[]{this.replicas, this.timeout, this.delay});
                if (delayStrategy == null) {
                    delayStrategy = DelayStrategy.constant((Duration)Duration.ofMillis(this.delay));
                }
                delayStrategy.sleepWhen(true);
            }
            LOGGER.warn("Failed to update {} replica(s) in {} millis.", (Object)this.replicas, (Object)this.timeout);
        }
        return result;
    }

    @Override
    public String info(String section) {
        return this.delegate.info(section);
    }
}

