/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.storage.configmap;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.DebeziumException;
import io.debezium.common.annotation.Incubating;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Incubating
public class ConfigMapFormatter {
    public static final String CONNECTOR_NAME_SEPARATOR = ".";
    public static final String ENTRIES_SEPARATOR = "_";
    public static final String KEY_VALUE_SEPARATOR = "-";
    private final ObjectMapper objectMapper;

    public ConfigMapFormatter(ObjectMapper mapper) {
        this.objectMapper = mapper;
    }

    public ConfigMapFormatter() {
        this.objectMapper = new ObjectMapper();
    }

    public Map<ByteBuffer, ByteBuffer> convertFromStorableFormat(Map<String, String> binaryData) {
        return binaryData.entrySet().stream().collect(Collectors.toMap(e -> this.fromStringKey((String)e.getKey()), e -> ByteBuffer.wrap(Base64.getDecoder().decode(((String)e.getValue()).getBytes()))));
    }

    public Map<String, String> convertToStorableFormat(Map<ByteBuffer, ByteBuffer> data) {
        return data.entrySet().stream().collect(Collectors.toMap(e -> this.toStringKey((ByteBuffer)e.getKey()), e -> new String(Base64.getEncoder().encode(((ByteBuffer)e.getValue()).array()))));
    }

    private ByteBuffer fromStringKey(String key) {
        String[] split = key.split("\\.");
        String[] entries = split[1].split(ENTRIES_SEPARATOR);
        Map<String, String> properties = Arrays.stream(entries).map(this::toEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        try {
            return ByteBuffer.wrap(this.objectMapper.writeValueAsBytes(List.of(split[0], properties)));
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Unable to parse key %s", key), (Throwable)e);
        }
    }

    private Map.Entry<String, String> toEntry(String storedEntry) {
        String[] keyAndValue = storedEntry.split(KEY_VALUE_SEPARATOR);
        return Map.entry(keyAndValue[0], keyAndValue[1]);
    }

    private String toStringKey(ByteBuffer key) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(key.array());
            StringBuilder keyBuilder = new StringBuilder();
            for (JsonNode node : jsonNode) {
                if (node.isTextual()) {
                    keyBuilder.append(String.format("%s%s", node.textValue(), CONNECTOR_NAME_SEPARATOR));
                    continue;
                }
                if (!node.isObject()) continue;
                Iterator fields = node.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    keyBuilder.append(String.format("%s%s%s", field.getKey(), KEY_VALUE_SEPARATOR, ((JsonNode)field.getValue()).asText()));
                    if (!fields.hasNext()) continue;
                    keyBuilder.append(ENTRIES_SEPARATOR);
                }
            }
            return keyBuilder.toString();
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Unable to format key %s to a format compatible with config map key", key));
        }
    }
}

