/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol.schema;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class SchemaData {
    private final SchemaType type;
    private final boolean isDeleted;
    private final long timestamp;
    private final String user;
    private final byte[] data;
    private Map<String, String> props;

    public SchemaInfo toSchemaInfo() {
        return SchemaInfo.builder().name("").type(this.type).schema(this.data).properties(this.props).build();
    }

    public static SchemaData fromSchemaInfo(SchemaInfo schemaInfo) {
        return SchemaData.builder().type(schemaInfo.getType()).data(schemaInfo.getSchema()).props(schemaInfo.getProperties()).build();
    }

    private static Map<String, String> $default$props() {
        return new HashMap<String, String>();
    }

    SchemaData(SchemaType type, boolean isDeleted, long timestamp, String user, byte[] data, Map<String, String> props) {
        this.type = type;
        this.isDeleted = isDeleted;
        this.timestamp = timestamp;
        this.user = user;
        this.data = data;
        this.props = props;
    }

    public static SchemaDataBuilder builder() {
        return new SchemaDataBuilder();
    }

    public SchemaType getType() {
        return this.type;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUser() {
        return this.user;
    }

    public byte[] getData() {
        return this.data;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaData)) {
            return false;
        }
        SchemaData other = (SchemaData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SchemaType this$type = this.getType();
        SchemaType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Map<String, String> this$props = this.getProps();
        Map<String, String> other$props = other.getProps();
        return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SchemaType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        Map<String, String> $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaData(type=" + this.getType() + ", isDeleted=" + this.isDeleted() + ", timestamp=" + this.getTimestamp() + ", user=" + this.getUser() + ", data=" + Arrays.toString(this.getData()) + ", props=" + this.getProps() + ")";
    }

    public static class SchemaDataBuilder {
        private SchemaType type;
        private boolean isDeleted;
        private long timestamp;
        private String user;
        private byte[] data;
        private boolean props$set;
        private Map<String, String> props$value;

        SchemaDataBuilder() {
        }

        public SchemaDataBuilder type(SchemaType type) {
            this.type = type;
            return this;
        }

        public SchemaDataBuilder isDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        public SchemaDataBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SchemaDataBuilder user(String user) {
            this.user = user;
            return this;
        }

        public SchemaDataBuilder data(byte[] data) {
            this.data = data;
            return this;
        }

        public SchemaDataBuilder props(Map<String, String> props) {
            this.props$value = props;
            this.props$set = true;
            return this;
        }

        public SchemaData build() {
            Map props$value = this.props$value;
            if (!this.props$set) {
                props$value = SchemaData.$default$props();
            }
            return new SchemaData(this.type, this.isDeleted, this.timestamp, this.user, this.data, props$value);
        }

        public String toString() {
            return "SchemaData.SchemaDataBuilder(type=" + this.type + ", isDeleted=" + this.isDeleted + ", timestamp=" + this.timestamp + ", user=" + this.user + ", data=" + Arrays.toString(this.data) + ", props$value=" + this.props$value + ")";
        }
    }
}

