/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.Objects;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;

public class PersistencePolicies {
    private int bookkeeperEnsemble;
    private int bookkeeperWriteQuorum;
    private int bookkeeperAckQuorum;
    private double managedLedgerMaxMarkDeleteRate;

    public PersistencePolicies() {
        this(2, 2, 2, 0.0);
    }

    public PersistencePolicies(int bookkeeperEnsemble, int bookkeeperWriteQuorum, int bookkeeperAckQuorum, double managedLedgerMaxMarkDeleteRate) {
        this.bookkeeperEnsemble = bookkeeperEnsemble;
        this.bookkeeperWriteQuorum = bookkeeperWriteQuorum;
        this.bookkeeperAckQuorum = bookkeeperAckQuorum;
        this.managedLedgerMaxMarkDeleteRate = managedLedgerMaxMarkDeleteRate;
    }

    public int getBookkeeperEnsemble() {
        return this.bookkeeperEnsemble;
    }

    public int getBookkeeperWriteQuorum() {
        return this.bookkeeperWriteQuorum;
    }

    public int getBookkeeperAckQuorum() {
        return this.bookkeeperAckQuorum;
    }

    public double getManagedLedgerMaxMarkDeleteRate() {
        return this.managedLedgerMaxMarkDeleteRate;
    }

    public int hashCode() {
        return Objects.hash(this.bookkeeperEnsemble, this.bookkeeperWriteQuorum, this.bookkeeperAckQuorum, this.managedLedgerMaxMarkDeleteRate);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PersistencePolicies) {
            PersistencePolicies other = (PersistencePolicies)obj;
            return this.bookkeeperEnsemble == other.bookkeeperEnsemble && this.bookkeeperWriteQuorum == other.bookkeeperWriteQuorum && this.bookkeeperAckQuorum == other.bookkeeperAckQuorum && this.managedLedgerMaxMarkDeleteRate == other.managedLedgerMaxMarkDeleteRate;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("e", this.bookkeeperEnsemble).add("w", this.bookkeeperWriteQuorum).add("a", this.bookkeeperAckQuorum).add("ml-md-rate", this.managedLedgerMaxMarkDeleteRate).toString();
    }
}

