/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.functions;

public class WorkerInfo {
    private String workerId;
    private String workerHostname;
    private int port;

    public static WorkerInfo of(String workerId, String workerHostname, int port) {
        return new WorkerInfo(workerId, workerHostname, port);
    }

    public static WorkerInfo parseFrom(String str) {
        String[] tokens = str.split(":");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Invalid string to parse WorkerInfo : " + str);
        }
        String workerId = tokens[0];
        String workerHostname = tokens[1];
        int port = Integer.parseInt(tokens[2]);
        return new WorkerInfo(workerId, workerHostname, port);
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public String getWorkerHostname() {
        return this.workerHostname;
    }

    public int getPort() {
        return this.port;
    }

    private WorkerInfo(String workerId, String workerHostname, int port) {
        this.workerId = workerId;
        this.workerHostname = workerHostname;
        this.port = port;
    }

    public WorkerInfo() {
    }

    public String toString() {
        return "WorkerInfo(workerId=" + this.getWorkerId() + ", workerHostname=" + this.getWorkerHostname() + ", port=" + this.getPort() + ")";
    }
}

