/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.api.schema.GenericRecordBuilder;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.generic.AvroRecordBuilderImpl;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroReader;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroWriter;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericAvroSchema
extends GenericSchemaImpl {
    private static final Logger log = LoggerFactory.getLogger(GenericAvroSchema.class);

    public GenericAvroSchema(SchemaInfo schemaInfo) {
        this(schemaInfo, true);
    }

    GenericAvroSchema(SchemaInfo schemaInfo, boolean useProvidedSchemaAsReaderSchema) {
        super(schemaInfo, useProvidedSchemaAsReaderSchema);
        this.setReader(new GenericAvroReader(this.schema));
        this.setWriter(new GenericAvroWriter(this.schema));
    }

    public GenericRecordBuilder newRecordBuilder() {
        return new AvroRecordBuilderImpl(this);
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    @Override
    public org.apache.pulsar.client.api.Schema<GenericRecord> clone() {
        GenericSchemaImpl schema = GenericAvroSchema.of(this.schemaInfo, this.useProvidedSchemaAsReaderSchema);
        if (this.schemaInfoProvider != null) {
            schema.setSchemaInfoProvider(this.schemaInfoProvider);
        }
        return schema;
    }

    @Override
    protected SchemaReader<GenericRecord> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo);
            Schema writerSchema = GenericAvroSchema.parseAvroSchema(schemaInfo.getSchemaDefinition());
            Schema readerSchema = this.useProvidedSchemaAsReaderSchema ? this.schema : writerSchema;
            return new GenericAvroReader(writerSchema, readerSchema, schemaVersion.get());
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.schemaInfo);
        return this.reader;
    }
}

