/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api.transaction;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.transaction.TransactionCoordinatorClientException;
import org.apache.pulsar.transaction.impl.common.TxnID;

public interface TransactionCoordinatorClient
extends Closeable {
    public static final long DEFAULT_TXN_TTL_MS = 60000L;

    public void start() throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> startAsync();

    public CompletableFuture<Void> closeAsync();

    public TxnID newTransaction() throws TransactionCoordinatorClientException;

    public CompletableFuture<TxnID> newTransactionAsync();

    public TxnID newTransaction(long var1, TimeUnit var3) throws TransactionCoordinatorClientException;

    public CompletableFuture<TxnID> newTransactionAsync(long var1, TimeUnit var3);

    public void addPublishPartitionToTxn(TxnID var1, List<String> var2) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> addPublishPartitionToTxnAsync(TxnID var1, List<String> var2);

    public void commit(TxnID var1) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> commitAsync(TxnID var1);

    public void abort(TxnID var1) throws TransactionCoordinatorClientException;

    public CompletableFuture<Void> abortAsync(TxnID var1);

    public State getState();

    public static enum State {
        NONE,
        STARTING,
        READY,
        CLOSING,
        CLOSED;

    }
}

