/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.isolation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

public class PluginScanResult {
    private final Collection<PluginDesc<Connector>> connectors;
    private final Collection<PluginDesc<Converter>> converters;
    private final Collection<PluginDesc<HeaderConverter>> headerConverters;
    private final Collection<PluginDesc<Transformation>> transformations;
    private final Collection<PluginDesc<Predicate>> predicates;
    private final Collection<PluginDesc<ConfigProvider>> configProviders;
    private final Collection<PluginDesc<ConnectRestExtension>> restExtensions;
    private final Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies;
    private final List<Collection> allPlugins;

    public PluginScanResult(Collection<PluginDesc<Connector>> connectors, Collection<PluginDesc<Converter>> converters, Collection<PluginDesc<HeaderConverter>> headerConverters, Collection<PluginDesc<Transformation>> transformations, Collection<PluginDesc<Predicate>> predicates, Collection<PluginDesc<ConfigProvider>> configProviders, Collection<PluginDesc<ConnectRestExtension>> restExtensions, Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies) {
        this.connectors = connectors;
        this.converters = converters;
        this.headerConverters = headerConverters;
        this.transformations = transformations;
        this.predicates = predicates;
        this.configProviders = configProviders;
        this.restExtensions = restExtensions;
        this.connectorClientConfigPolicies = connectorClientConfigPolicies;
        this.allPlugins = Arrays.asList(connectors, converters, headerConverters, transformations, configProviders, connectorClientConfigPolicies);
    }

    public Collection<PluginDesc<Connector>> connectors() {
        return this.connectors;
    }

    public Collection<PluginDesc<Converter>> converters() {
        return this.converters;
    }

    public Collection<PluginDesc<HeaderConverter>> headerConverters() {
        return this.headerConverters;
    }

    public Collection<PluginDesc<Transformation>> transformations() {
        return this.transformations;
    }

    public Collection<PluginDesc<Predicate>> predicates() {
        return this.predicates;
    }

    public Collection<PluginDesc<ConfigProvider>> configProviders() {
        return this.configProviders;
    }

    public Collection<PluginDesc<ConnectRestExtension>> restExtensions() {
        return this.restExtensions;
    }

    public Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.connectorClientConfigPolicies;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        for (Collection plugins : this.allPlugins) {
            isEmpty = isEmpty && plugins.isEmpty();
        }
        return isEmpty;
    }
}

