/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.converters;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterConfig;
import org.apache.kafka.connect.storage.HeaderConverter;

public class ByteArrayConverter
implements Converter,
HeaderConverter {
    private static final ConfigDef CONFIG_DEF = ConverterConfig.newConfigDef();

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void configure(Map<String, ?> configs) {
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        if (schema != null && schema.type() != Schema.Type.BYTES) {
            throw new DataException("Invalid schema type for ByteArrayConverter: " + schema.type().toString());
        }
        if (value != null && !(value instanceof byte[])) {
            throw new DataException("ByteArrayConverter is not compatible with objects of type " + value.getClass());
        }
        return (byte[])value;
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return new SchemaAndValue(Schema.OPTIONAL_BYTES_SCHEMA, (Object)value);
    }

    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    public void close() {
    }
}

