/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.control.RequestContextController;

@Dependent
public class InjectableRequestContextController
implements RequestContextController {
    private final ManagedContext requestContext = Arc.container().requestContext();
    private final AtomicBoolean isActivator = new AtomicBoolean(false);

    public boolean activate() {
        if (Arc.container().getActiveContext(RequestScoped.class) != null) {
            return false;
        }
        this.requestContext.activate();
        this.isActivator.set(true);
        return true;
    }

    public void deactivate() throws ContextNotActiveException {
        if (Arc.container().getActiveContext(RequestScoped.class) == null) {
            throw new ContextNotActiveException(RequestScoped.class.getName());
        }
        if (this.isActivator.compareAndSet(true, false)) {
            this.requestContext.terminate();
        }
    }
}

