/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.impl.InterceptorInvocation;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.arc.impl.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

abstract class AbstractInvocationContext
implements ArcInvocationContext,
Supplier<Map<String, Object>> {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    protected final Method method;
    protected final Constructor<?> constructor;
    protected final Set<Annotation> interceptorBindings;
    protected final List<InterceptorInvocation> chain;
    protected Object target;
    protected Object[] parameters;
    protected LazyValue<Map<String, Object>> contextData;

    protected AbstractInvocationContext(Object target, Method method, Constructor<?> constructor, Object[] parameters, LazyValue<Map<String, Object>> contextData, Set<Annotation> interceptorBindings, List<InterceptorInvocation> chain) {
        this.target = target;
        this.method = method;
        this.constructor = constructor;
        this.parameters = parameters != null ? parameters : EMPTY_PARAMS;
        this.contextData = contextData != null ? contextData : new LazyValue<Map<String, Object>>(this);
        this.interceptorBindings = interceptorBindings;
        this.chain = chain;
    }

    public Map<String, Object> getContextData() {
        return this.contextData.get();
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return Collections.unmodifiableSet(this.interceptorBindings);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        this.validateParameters(params);
        this.parameters = params;
    }

    protected void validateParameters(Object[] params) {
        int newParametersCount = Objects.requireNonNull(params).length;
        Object[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length != newParametersCount) {
            throw new IllegalArgumentException("Wrong number of parameters - method has " + Arrays.toString(parameterTypes) + ", attempting to set " + Arrays.toString(params));
        }
        for (int i = 0; i < params.length; ++i) {
            if (((Class)parameterTypes[i]).isPrimitive() && params[i] == null) {
                throw new IllegalArgumentException("Trying to set a null value to a primitive parameter [position: " + i + ", type: " + (Class)parameterTypes[i] + "]");
            }
            if (params[i] == null || Types.boxedClass(parameterTypes[i]).isAssignableFrom(Types.boxedClass(params[i].getClass()))) continue;
            throw new IllegalArgumentException("The parameter type [" + params[i].getClass() + "] can not be assigned to the type for the target method [" + (Class)parameterTypes[i] + "]");
        }
    }

    public Object getTarget() {
        return this.target;
    }

    public Object getTimer() {
        return null;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    @Override
    public Map<String, Object> get() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("io.quarkus.arc.interceptorBindings", this.interceptorBindings);
        return result;
    }
}

