/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v2;

import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.rest.v2.beans.VersionSearchResults;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.types.RuleType;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/apis/registry/v2/groups")
public interface GroupsResource {
    @Path(value="/{groupId}/artifacts")
    @GET
    @Produces(value={"application/json"})
    public ArtifactSearchResults listArtifactsInGroup(@PathParam(value="groupId") String var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="offset") Integer var3, @QueryParam(value="order") SortOrder var4, @QueryParam(value="orderby") SortBy var5);

    @Path(value="/{groupId}/artifacts")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<ArtifactMetaData> createArtifact(@PathParam(value="groupId") String var1, @HeaderParam(value="X-Registry-ArtifactType") ArtifactType var2, @HeaderParam(value="X-Registry-ArtifactId") String var3, @HeaderParam(value="X-Registry-Version") String var4, @QueryParam(value="ifExists") IfExists var5, @QueryParam(value="canonical") Boolean var6, InputStream var7);

    @Path(value="/{groupId}/artifacts")
    @DELETE
    public void deleteArtifactsInGroup(@PathParam(value="groupId") String var1);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @GET
    @Produces(value={"*/*"})
    public Response getLatestArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<ArtifactMetaData> updateArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, InputStream var4);

    @Path(value="/{groupId}/artifacts/{artifactId}")
    @DELETE
    public void deleteArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactState(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, UpdateState var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @GET
    @Produces(value={"application/json"})
    public ArtifactMetaData getArtifactMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, EditableMetaData var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/meta")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public VersionMetaData getArtifactVersionMetaDataByContent(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="canonical") Boolean var3, InputStream var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @GET
    @Produces(value={"application/json"})
    public VersionMetaData getArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, EditableMetaData var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/meta")
    @DELETE
    public void deleteArtifactVersionMetaData(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @GET
    @Produces(value={"application/json"})
    public VersionSearchResults listArtifactVersions(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @QueryParam(value="offset") Integer var3, @QueryParam(value="limit") Integer var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public CompletionStage<VersionMetaData> createArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @HeaderParam(value="X-Registry-Version") String var3, InputStream var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}")
    @GET
    @Produces(value={"*/*"})
    public Response getArtifactVersion(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/versions/{version}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionState(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="version") String var3, UpdateState var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listArtifactRules(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createArtifactRule(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, Rule var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules")
    @DELETE
    public void deleteArtifactRules(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getArtifactRuleConfig(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateArtifactRuleConfig(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3, Rule var4);

    @Path(value="/{groupId}/artifacts/{artifactId}/rules/{rule}")
    @DELETE
    public void deleteArtifactRule(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, @PathParam(value="rule") RuleType var3);

    @Path(value="/{groupId}/artifacts/{artifactId}/test")
    @PUT
    @Consumes(value={"*/*"})
    public void testUpdateArtifact(@PathParam(value="groupId") String var1, @PathParam(value="artifactId") String var2, InputStream var3);
}

