/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.registry.auth.Auth;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class BasicAuth
implements Auth {
    public static final String BASIC = "Basic ";
    private final String username;
    private final String password;

    public BasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void apply(Map<String, String> requestHeaders) {
        String usernameAndPassword = this.username + ":" + this.password;
        String encoded = Base64.encodeBase64String((byte[])usernameAndPassword.getBytes(StandardCharsets.UTF_8));
        requestHeaders.put("Authorization", BASIC + encoded);
    }

    public static class Builder {
        private String username;
        private String password;

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withClientId(String password) {
            this.password = password;
            return this;
        }

        public BasicAuth build() {
            return new BasicAuth(this.username, this.password);
        }
    }
}

