/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.logging.AsyncConfig;
import io.quarkus.runtime.logging.BannerFormatter;
import io.quarkus.runtime.logging.CategoryBuildTimeConfig;
import io.quarkus.runtime.logging.CategoryConfig;
import io.quarkus.runtime.logging.CleanupFilterConfig;
import io.quarkus.runtime.logging.ConsoleConfig;
import io.quarkus.runtime.logging.FileConfig;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LogBuildTimeConfig;
import io.quarkus.runtime.logging.LogCleanupFilter;
import io.quarkus.runtime.logging.LogCleanupFilterElement;
import io.quarkus.runtime.logging.LogConfig;
import io.quarkus.runtime.logging.SyslogConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.ImageInfo;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.formatters.ColorPatternFormatter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.PeriodicSizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.handlers.SyslogHandler;
import org.wildfly.common.net.HostName;
import org.wildfly.common.os.Process;

@Recorder
public class LoggingSetupRecorder {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(LoggingSetupRecorder.class);

    public static void handleFailedStart() {
        LoggingSetupRecorder.handleFailedStart(new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()));
    }

    public static void handleFailedStart(RuntimeValue<Optional<Supplier<String>>> banner) {
        LogConfig config = new LogConfig();
        ConfigInstantiator.handleObject(config);
        LogBuildTimeConfig buildConfig = new LogBuildTimeConfig();
        ConfigInstantiator.handleObject(buildConfig);
        new LoggingSetupRecorder().initializeLogging(config, buildConfig, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), banner);
    }

    public void initializeLogging(LogConfig config, LogBuildTimeConfig buildConfig, List<RuntimeValue<Optional<Handler>>> additionalHandlers, List<RuntimeValue<Map<String, Handler>>> additionalNamedHandlers, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier) {
        Handler syslogHandler;
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level);
        Object errorManager = new OnlyOnceErrorManager();
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry<String, CleanupFilterConfig> entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement(entry.getKey(), entry.getValue().targetLevel, entry.getValue().ifStartsWith));
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(3 + additionalHandlers.size());
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, (ErrorManager)errorManager, filterElements, possibleFormatters, possibleBannerSupplier);
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        if (config.file.enable) {
            handlers.add(LoggingSetupRecorder.configureFileHandler(config.file, (ErrorManager)errorManager, filterElements));
        }
        if (config.syslog.enable && (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(config.syslog, (ErrorManager)errorManager, filterElements)) != null) {
            handlers.add(syslogHandler);
        }
        Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, possibleFormatters, (ErrorManager)errorManager, filterElements);
        Map<String, Handler> additionalNamedHandlersMap = additionalNamedHandlers.stream().map(RuntimeValue::getValue).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        for (Handler handler : additionalNamedHandlersMap.values()) {
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
        }
        namedHandlers.putAll(additionalNamedHandlersMap);
        for (Map.Entry entry : categories.entrySet()) {
            Level minLogLevel;
            CategoryBuildTimeConfig buildCategory = LoggingSetupRecorder.isSubsetOf((String)entry.getKey(), buildConfig.categories);
            Level logLevel = LoggingSetupRecorder.getLogLevel((String)entry.getKey(), (CategoryConfig)entry.getValue(), categories, buildConfig.minLevel);
            Level level = minLogLevel = buildCategory == null ? buildConfig.minLevel : buildCategory.minLevel.getLevel();
            if (logLevel.intValue() >= minLogLevel.intValue()) continue;
            log.warnf("Log level %s for category '%s' set below minimum logging level %s, promoting it to %s", new Object[]{logLevel, entry.getKey(), minLogLevel, minLogLevel});
            ((CategoryConfig)entry.getValue()).level = InheritableLevel.of(minLogLevel.toString());
        }
        for (Map.Entry entry : categories.entrySet()) {
            String name = (String)entry.getKey();
            Logger categoryLogger = logContext.getLogger(name);
            CategoryConfig categoryConfig = (CategoryConfig)entry.getValue();
            if (!categoryConfig.level.isInherited()) {
                categoryLogger.setLevel(categoryConfig.level.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers);
            if (!categoryConfig.handlers.isPresent()) continue;
            LoggingSetupRecorder.addNamedHandlersToCategory(categoryConfig, namedHandlers, categoryLogger, (ErrorManager)errorManager);
        }
        for (RuntimeValue runtimeValue : additionalHandlers) {
            Optional optional = (Optional)runtimeValue.getValue();
            if (!optional.isPresent()) continue;
            Handler handler = (Handler)optional.get();
            handler.setErrorManager((ErrorManager)errorManager);
            handler.setFilter(new LogCleanupFilter(filterElements));
            handlers.add(handler);
        }
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    public static void initializeBuildTimeLogging(LogConfig config, LogBuildTimeConfig buildConfig) {
        Map<String, CategoryConfig> categories = config.categories;
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        rootLogger.setLevel(config.level);
        Object errorManager = new OnlyOnceErrorManager();
        Map<String, CleanupFilterConfig> filters = config.filters;
        ArrayList<LogCleanupFilterElement> filterElements = new ArrayList<LogCleanupFilterElement>(filters.size());
        for (Map.Entry<String, CleanupFilterConfig> entry : filters.entrySet()) {
            filterElements.add(new LogCleanupFilterElement(entry.getKey(), entry.getValue().targetLevel, entry.getValue().ifStartsWith));
        }
        ArrayList<Handler> handlers = new ArrayList<Handler>(3);
        if (config.console.enable) {
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(config.console, (ErrorManager)errorManager, filterElements, Collections.emptyList(), new RuntimeValue<Optional<Supplier<String>>>(Optional.empty()));
            errorManager = consoleHandler.getErrorManager();
            handlers.add(consoleHandler);
        }
        Map<String, Handler> namedHandlers = LoggingSetupRecorder.createNamedHandlers(config, Collections.emptyList(), (ErrorManager)errorManager, filterElements);
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            Level minLogLevel;
            CategoryBuildTimeConfig buildCategory = LoggingSetupRecorder.isSubsetOf(entry.getKey(), buildConfig.categories);
            Level logLevel = LoggingSetupRecorder.getLogLevel(entry.getKey(), entry.getValue(), categories, buildConfig.minLevel);
            Level level = minLogLevel = buildCategory == null ? buildConfig.minLevel : buildCategory.minLevel.getLevel();
            if (logLevel.intValue() >= minLogLevel.intValue()) continue;
            log.warnf("Log level %s for category '%s' set below minimum logging level %s, promoting it to %s", new Object[]{logLevel, entry.getKey(), minLogLevel, minLogLevel});
            entry.getValue().level = InheritableLevel.of(minLogLevel.toString());
        }
        for (Map.Entry<String, CategoryConfig> entry : categories.entrySet()) {
            String name = entry.getKey();
            Logger categoryLogger = logContext.getLogger(name);
            CategoryConfig categoryConfig = entry.getValue();
            if (!categoryConfig.level.isInherited()) {
                categoryLogger.setLevel(categoryConfig.level.getLevel());
            }
            categoryLogger.setUseParentHandlers(categoryConfig.useParentHandlers);
            if (!categoryConfig.handlers.isPresent()) continue;
            LoggingSetupRecorder.addNamedHandlersToCategory(categoryConfig, namedHandlers, categoryLogger, (ErrorManager)errorManager);
        }
        InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
        InitialConfigurator.DELAYED_HANDLER.setBuildTimeHandlers(handlers.toArray(EmbeddedConfigurator.NO_HANDLERS));
    }

    private static Level getLogLevel(String categoryName, CategoryConfig categoryConfig, Map<String, CategoryConfig> categories, Level rootMinLevel) {
        if (Objects.isNull(categoryConfig)) {
            return rootMinLevel;
        }
        InheritableLevel inheritableLevel = categoryConfig.level;
        if (!inheritableLevel.isInherited()) {
            return inheritableLevel.getLevel();
        }
        int lastDotIndex = categoryName.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return rootMinLevel;
        }
        String parent = categoryName.substring(0, lastDotIndex);
        return LoggingSetupRecorder.getLogLevel(parent, categories.get(parent), categories, rootMinLevel);
    }

    private static CategoryBuildTimeConfig isSubsetOf(String categoryName, Map<String, CategoryBuildTimeConfig> categories) {
        return categories.entrySet().stream().filter(buildCategoryEntry -> categoryName.startsWith((String)buildCategoryEntry.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static Map<String, Handler> createNamedHandlers(LogConfig config, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        HashMap<String, Handler> namedHandlers = new HashMap<String, Handler>();
        for (Map.Entry<String, ConsoleConfig> entry : config.consoleHandlers.entrySet()) {
            ConsoleConfig namedConsoleConfig = entry.getValue();
            if (!namedConsoleConfig.enable) continue;
            Handler consoleHandler = LoggingSetupRecorder.configureConsoleHandler(namedConsoleConfig, errorManager, filterElements, possibleFormatters, null);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, consoleHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.fileHandlers.entrySet()) {
            FileConfig namedFileConfig = (FileConfig)entry.getValue();
            if (!namedFileConfig.enable) continue;
            Handler fileHandler = LoggingSetupRecorder.configureFileHandler(namedFileConfig, errorManager, filterElements);
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, fileHandler, entry.getKey());
        }
        for (Map.Entry<String, Object> entry : config.syslogHandlers.entrySet()) {
            Handler syslogHandler;
            SyslogConfig namedSyslogConfig = (SyslogConfig)entry.getValue();
            if (!namedSyslogConfig.enable || (syslogHandler = LoggingSetupRecorder.configureSyslogHandler(namedSyslogConfig, errorManager, filterElements)) == null) continue;
            LoggingSetupRecorder.addToNamedHandlers(namedHandlers, syslogHandler, entry.getKey());
        }
        return namedHandlers;
    }

    private static void addToNamedHandlers(Map<String, Handler> namedHandlers, final Handler handler, String handlerName) {
        if (namedHandlers.containsKey(handlerName)) {
            throw new RuntimeException(String.format("Only one handler can be configured with the same name '%s'", handlerName));
        }
        namedHandlers.put(handlerName, handler);
        InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

            @Override
            public void run() {
                handler.close();
            }
        });
    }

    private static void addNamedHandlersToCategory(CategoryConfig categoryConfig, Map<String, Handler> namedHandlers, final Logger categoryLogger, ErrorManager errorManager) {
        for (String categoryNamedHandler : categoryConfig.handlers.get()) {
            final Handler handler = namedHandlers.get(categoryNamedHandler);
            if (handler != null) {
                categoryLogger.addHandler(handler);
                InitialConfigurator.DELAYED_HANDLER.addLoggingCloseTask(new Runnable(){

                    @Override
                    public void run() {
                        categoryLogger.removeHandler(handler);
                    }
                });
                continue;
            }
            errorManager.error(String.format("Handler with name '%s' is linked to a category but not configured.", categoryNamedHandler), null, 0);
        }
    }

    public void initializeLoggingForImageBuild() {
        if (ImageInfo.inImageBuildtimeCode()) {
            ConsoleHandler handler = new ConsoleHandler((Formatter)new PatternFormatter("%d{HH:mm:ss,SSS} %-5p [%c{1.}] %s%e%n"));
            handler.setLevel(Level.INFO);
            InitialConfigurator.DELAYED_HANDLER.setAutoFlush(false);
            InitialConfigurator.DELAYED_HANDLER.setHandlers(new Handler[]{handler});
        }
    }

    private static Handler configureConsoleHandler(ConsoleConfig config, ErrorManager defaultErrorManager, List<LogCleanupFilterElement> filterElements, List<RuntimeValue<Optional<Formatter>>> possibleFormatters, RuntimeValue<Optional<Supplier<String>>> possibleBannerSupplier) {
        ConsoleHandler handler;
        Object formatter = null;
        boolean formatterWarning = false;
        for (RuntimeValue<Optional<Formatter>> value : possibleFormatters) {
            Optional<Formatter> val;
            if (formatter != null) {
                formatterWarning = true;
            }
            if (!(val = value.getValue()).isPresent()) continue;
            formatter = val.get();
        }
        if (formatter == null) {
            Supplier<String> bannerSupplier = null;
            if (possibleBannerSupplier != null && possibleBannerSupplier.getValue().isPresent()) {
                bannerSupplier = possibleBannerSupplier.getValue().get();
            }
            if (config.color.orElse(QuarkusConsole.hasColorSupport()).booleanValue()) {
                ColorPatternFormatter colorPatternFormatter = new ColorPatternFormatter(config.darken, config.format);
                formatter = bannerSupplier != null ? new BannerFormatter((Formatter)colorPatternFormatter, true, bannerSupplier) : colorPatternFormatter;
            } else {
                PatternFormatter patternFormatter = new PatternFormatter(config.format);
                formatter = bannerSupplier != null ? new BannerFormatter((Formatter)patternFormatter, false, bannerSupplier) : patternFormatter;
            }
        }
        ConsoleHandler consoleHandler = new ConsoleHandler(config.stderr ? ConsoleHandler.Target.SYSTEM_ERR : ConsoleHandler.Target.SYSTEM_OUT, formatter);
        consoleHandler.setLevel(config.level);
        consoleHandler.setErrorManager(defaultErrorManager);
        consoleHandler.setFilter((Filter)new LogCleanupFilter(filterElements));
        Object object = handler = config.async.enable ? LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)consoleHandler) : consoleHandler;
        if (formatterWarning) {
            handler.getErrorManager().error("Multiple formatters were activated", null, 0);
        }
        return handler;
    }

    private static Handler configureFileHandler(FileConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        FileHandler handler = new FileHandler();
        FileConfig.RotationConfig rotationConfig = config.rotation;
        if ((rotationConfig.maxFileSize.isPresent() || rotationConfig.rotateOnBoot) && rotationConfig.fileSuffix.isPresent()) {
            PeriodicSizeRotatingFileHandler periodicSizeRotatingFileHandler = new PeriodicSizeRotatingFileHandler();
            periodicSizeRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            rotationConfig.maxFileSize.ifPresent(memorySize -> periodicSizeRotatingFileHandler.setRotateSize(memorySize.asLongValue()));
            periodicSizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            periodicSizeRotatingFileHandler.setMaxBackupIndex(rotationConfig.maxBackupIndex);
            handler = periodicSizeRotatingFileHandler;
        } else if (rotationConfig.maxFileSize.isPresent()) {
            SizeRotatingFileHandler sizeRotatingFileHandler = new SizeRotatingFileHandler(rotationConfig.maxFileSize.get().asLongValue(), rotationConfig.maxBackupIndex);
            sizeRotatingFileHandler.setRotateOnBoot(rotationConfig.rotateOnBoot);
            handler = sizeRotatingFileHandler;
        } else if (rotationConfig.fileSuffix.isPresent()) {
            PeriodicRotatingFileHandler periodicRotatingFileHandler = new PeriodicRotatingFileHandler();
            periodicRotatingFileHandler.setSuffix(rotationConfig.fileSuffix.get());
            handler = periodicRotatingFileHandler;
        }
        PatternFormatter formatter = new PatternFormatter(config.format);
        handler.setFormatter((Formatter)formatter);
        handler.setAppend(true);
        try {
            handler.setFile(config.path);
        }
        catch (FileNotFoundException e) {
            errorManager.error("Failed to set log file", e, 4);
        }
        handler.setErrorManager(errorManager);
        handler.setLevel(config.level);
        handler.setFilter((Filter)new LogCleanupFilter(filterElements));
        if (config.async.enable) {
            return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)handler);
        }
        return handler;
    }

    private static Handler configureSyslogHandler(SyslogConfig config, ErrorManager errorManager, List<LogCleanupFilterElement> filterElements) {
        try {
            SyslogHandler handler = new SyslogHandler(config.endpoint.getHostString(), config.endpoint.getPort());
            handler.setAppName(config.appName.orElse(Process.getProcessName()));
            handler.setHostname(config.hostname.orElse(HostName.getQualifiedHostName()));
            handler.setFacility(config.facility);
            handler.setSyslogType(config.syslogType);
            handler.setProtocol(config.protocol);
            handler.setBlockOnReconnect(config.blockOnReconnect);
            handler.setTruncate(config.truncate);
            handler.setUseCountingFraming(config.useCountingFraming);
            handler.setLevel(config.level);
            PatternFormatter formatter = new PatternFormatter(config.format);
            handler.setFormatter((Formatter)formatter);
            handler.setErrorManager(errorManager);
            handler.setFilter((Filter)new LogCleanupFilter(filterElements));
            if (config.async.enable) {
                return LoggingSetupRecorder.createAsyncHandler(config.async, config.level, (Handler)handler);
            }
            return handler;
        }
        catch (IOException e) {
            errorManager.error("Failed to create syslog handler", e, 4);
            return null;
        }
    }

    private static AsyncHandler createAsyncHandler(AsyncConfig asyncConfig, Level level, Handler handler) {
        AsyncHandler asyncHandler = new AsyncHandler(asyncConfig.queueLength);
        asyncHandler.setOverflowAction(asyncConfig.overflow);
        asyncHandler.addHandler(handler);
        asyncHandler.setLevel(level);
        return asyncHandler;
    }
}

