/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.protocol.netty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

public abstract class FlushingMessageToByteEncoder<I>
extends MessageToByteEncoder<I> {
    private final AtomicBoolean shouldFlush = new AtomicBoolean(false);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        super.write(ctx, msg, promise);
        if (this.shouldFlush.compareAndSet(true, false)) {
            ctx.flush();
        }
    }

    protected void flushRequired() {
        this.shouldFlush.set(true);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FlushingMessageToByteEncoder() {
    }
}

