/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.Version;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class TableKey<KeyT> {
    @NonNull
    private final KeyT key;
    private final Version version;

    public static <KeyT> TableKey<KeyT> unversioned(KeyT key) {
        return TableKey.versioned(key, Version.NO_VERSION);
    }

    public static <KeyT> TableKey<KeyT> notExists(KeyT key) {
        return TableKey.versioned(key, Version.NOT_EXISTS);
    }

    public static <KeyT> TableKey<KeyT> versioned(KeyT key, Version version) {
        return new TableKey<KeyT>(key, version);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyT getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Version getVersion() {
        return this.version;
    }

    @ConstructorProperties(value={"key", "version"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private TableKey(@NonNull KeyT key, Version version) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.version = version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "TableKey(key=" + this.getKey() + ", version=" + this.getVersion() + ")";
    }
}

