/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.tables.KeyValueTable;
import io.pravega.client.tables.KeyValueTableClientConfiguration;
import io.pravega.client.tables.impl.KeyValueTableFactoryImpl;
import lombok.NonNull;

public interface KeyValueTableFactory
extends AutoCloseable {
    public static KeyValueTableFactory withScope(String scope, ClientConfig config) {
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(config);
        ConnectionPoolImpl connectionPool = new ConnectionPoolImpl(config, connectionFactory);
        ControllerImpl controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        return new KeyValueTableFactoryImpl(scope, controller, connectionPool);
    }

    public <KeyT, ValueT> KeyValueTable<KeyT, ValueT> forKeyValueTable(@NonNull String var1, @NonNull Serializer<KeyT> var2, @NonNull Serializer<ValueT> var3, @NonNull KeyValueTableClientConfiguration var4);

    @Override
    public void close();
}

