/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;
import lombok.NonNull;

@NotThreadSafe
public class SimpleDeque<T> {
    private static final int MAX_CAPACITY = 0x7FFFFFF7;
    private static final int MAX_HALF = 0x3FFFFFFB;
    private Object[] items;
    private int head;
    private int tail;

    public SimpleDeque() {
        this(16);
    }

    public SimpleDeque(int initialCapacity) {
        Preconditions.checkArgument((initialCapacity >= 0 ? 1 : 0) != 0, (Object)"initialCapacity must be a non-negative number.");
        this.items = new Object[initialCapacity + 1];
    }

    public void addLast(@NonNull T item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.items[this.tail] = item;
        this.tail = this.increment(this.tail);
        if (this.head == this.tail) {
            this.expand();
        }
    }

    public T pollFirst() {
        Object e = this.items[this.head];
        if (e != null) {
            this.items[this.head] = null;
            this.head = this.increment(this.head);
        }
        return (T)e;
    }

    public Queue<T> pollFirst(int maxCount) {
        int count = Math.min(maxCount, this.size());
        Object[] result = new Object[count];
        if (count == 0) {
            return new WrapQueue(result);
        }
        int copyLength = Math.min(this.items.length - this.head, count);
        System.arraycopy(this.items, this.head, result, 0, copyLength);
        Arrays.fill(this.items, this.head, this.head + copyLength, null);
        this.head += copyLength;
        if (this.head == this.items.length) {
            this.head = 0;
        }
        if ((count -= copyLength) > 0) {
            System.arraycopy(this.items, 0, result, copyLength, count);
            Arrays.fill(this.items, 0, count, null);
            this.head += count;
        }
        return new WrapQueue(result);
    }

    public T peekFirst() {
        return (T)this.items[this.head];
    }

    public int size() {
        int size = this.tail - this.head;
        return size < 0 ? size + this.items.length : size;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void clear() {
        Arrays.fill(this.items, null);
        this.head = 0;
        this.tail = 0;
    }

    private int increment(int index) {
        return ++index == this.items.length ? 0 : index;
    }

    private void expand() {
        int newCapacity = this.items.length;
        if (this.items.length >= 0x7FFFFFF7) {
            throw new OutOfMemoryError("Unable to grow SimpleDequeue.");
        }
        newCapacity = newCapacity >= 0x3FFFFFFB ? 0x7FFFFFF7 : (newCapacity *= 2);
        Object[] newItems = new Object[newCapacity];
        if (this.head < this.tail) {
            int size = this.tail - this.head;
            System.arraycopy(this.items, this.head, newItems, 0, size);
            this.tail = size;
        } else {
            int copyLength = this.items.length - this.head;
            System.arraycopy(this.items, this.head, newItems, 0, copyLength);
            System.arraycopy(this.items, 0, newItems, copyLength, this.tail);
            this.tail = copyLength + this.tail;
        }
        this.head = 0;
        this.items = newItems;
        assert (this.head != this.tail);
    }

    public String toString() {
        return String.format("Size = %s, Capacity = %s, Head = %s, Tail = %s", this.size(), this.items.length, this.head, this.tail);
    }

    @NotThreadSafe
    private static class WrapQueue<T>
    extends AbstractCollection<T>
    implements Queue<T> {
        private final Object[] items;
        private int nextIndex = 0;

        @Override
        public T poll() {
            if (this.nextIndex >= this.items.length) {
                return null;
            }
            return (T)this.items[this.nextIndex++];
        }

        @Override
        public T element() {
            T result = this.peek();
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public T peek() {
            return (T)(this.nextIndex >= this.items.length ? null : this.items[this.nextIndex]);
        }

        @Override
        public Iterator<T> iterator() {
            return Arrays.stream(this.items).skip(this.nextIndex).map(o -> o).iterator();
        }

        @Override
        public int size() {
            return this.items.length - this.nextIndex;
        }

        @Override
        public T remove() {
            T result = this.poll();
            if (result == null) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean offer(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @ConstructorProperties(value={"items"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public WrapQueue(Object[] items) {
            this.items = items;
        }
    }
}

