/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SimpleCache<KeyT, ValueT> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SimpleCache.class);
    @GuardedBy(value="lock")
    private final HashMap<KeyT, Entry<KeyT, ValueT>> map;
    private final int maxSize;
    private final long expirationTimeNanos;
    private final BiConsumer<KeyT, ValueT> onExpiration;
    private final Supplier<Long> currentTime;
    @GuardedBy(value="lock")
    private Entry<KeyT, ValueT> leastRecent;
    @GuardedBy(value="lock")
    private Entry<KeyT, ValueT> mostRecent;
    private final Object lock = new Object();

    public SimpleCache(int maxSize, @NonNull Duration expirationTime, @Nullable BiConsumer<KeyT, ValueT> onExpiration) {
        this(maxSize, expirationTime, onExpiration, System::nanoTime);
        if (expirationTime == null) {
            throw new NullPointerException("expirationTime is marked non-null but is null");
        }
    }

    @VisibleForTesting
    SimpleCache(int maxSize, @NonNull Duration expirationTime, @Nullable BiConsumer<KeyT, ValueT> onExpiration, @NonNull Supplier<Long> currentTime) {
        if (expirationTime == null) {
            throw new NullPointerException("expirationTime is marked non-null but is null");
        }
        if (currentTime == null) {
            throw new NullPointerException("currentTime is marked non-null but is null");
        }
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize must be a positive number.");
        this.expirationTimeNanos = expirationTime.toNanos();
        Preconditions.checkArgument((this.expirationTimeNanos > 0L ? 1 : 0) != 0, (Object)"expirationTime must be a positive duration.");
        this.map = new HashMap();
        this.onExpiration = onExpiration;
        this.currentTime = currentTime;
        this.maxSize = maxSize;
        this.leastRecent = null;
        this.mostRecent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueT put(KeyT key, ValueT value) {
        Entry<KeyT, ValueT> prevValue;
        Entry<KeyT, ValueT> e = new Entry<KeyT, ValueT>(key, value);
        e.lastAccessTime = this.currentTime.get();
        Object object = this.lock;
        synchronized (object) {
            prevValue = this.map.put(key, e);
            if (prevValue != null) {
                if (this.isExpired(prevValue, e.lastAccessTime)) {
                    prevValue.replaced = true;
                    prevValue = null;
                } else {
                    this.unregister(prevValue);
                }
            }
            this.register(e);
        }
        if (prevValue == null) {
            this.cleanUp();
            return null;
        }
        return prevValue.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueT putIfAbsent(KeyT key, ValueT value) {
        Entry<KeyT, ValueT> prevValue;
        Entry<KeyT, ValueT> e = new Entry<KeyT, ValueT>(key, value);
        e.lastAccessTime = this.currentTime.get();
        Object object = this.lock;
        synchronized (object) {
            prevValue = this.map.putIfAbsent(key, e);
            if (prevValue != null && this.isExpired(prevValue, e.lastAccessTime)) {
                this.map.put(key, e);
                prevValue.replaced = true;
                prevValue = null;
            }
            if (prevValue == null) {
                this.register(e);
            }
        }
        if (prevValue == null) {
            this.cleanUp();
            return null;
        }
        return prevValue.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueT remove(KeyT key) {
        Entry<KeyT, ValueT> e;
        long currentTime = this.currentTime.get();
        Object object = this.lock;
        synchronized (object) {
            e = this.map.remove(key);
            if (e != null) {
                this.unregister(e);
                if (this.isExpired(e, currentTime)) {
                    return null;
                }
            }
        }
        return e == null ? null : (ValueT)e.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueT get(KeyT key) {
        Entry<KeyT, ValueT> e;
        boolean needsEviction = false;
        long currentTime = this.currentTime.get();
        Object object = this.lock;
        synchronized (object) {
            e = this.map.get(key);
            if (e != null) {
                if (this.isExpired(e, currentTime)) {
                    needsEviction = true;
                    e = null;
                } else {
                    e.lastAccessTime = currentTime;
                    this.unregister(e);
                    this.register(e);
                }
            }
        }
        if (needsEviction) {
            this.cleanUp();
            return null;
        }
        return e == null ? null : (ValueT)e.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        Entry<KeyT, ValueT> lastEvicted;
        long currentTime = this.currentTime.get();
        Object object = this.lock;
        synchronized (object) {
            Entry<KeyT, ValueT> current = this.leastRecent;
            while (current != null && (this.isExpired(current, currentTime) || this.map.size() > this.maxSize)) {
                if (!current.replaced) {
                    this.map.remove(current.key);
                }
                current = current.next;
            }
            this.leastRecent = current;
            if (current == null) {
                lastEvicted = this.mostRecent;
                this.mostRecent = null;
            } else {
                lastEvicted = current.prev;
                if (lastEvicted != null) {
                    lastEvicted.next = null;
                    current.prev = null;
                }
            }
        }
        if (this.onExpiration != null) {
            while (lastEvicted != null) {
                try {
                    this.onExpiration.accept(lastEvicted.key, lastEvicted.value);
                }
                catch (Throwable ex) {
                    log.error("Eviction callback for {} failed.", lastEvicted.key, (Object)ex);
                }
                lastEvicted = lastEvicted.prev;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<Map.Entry<KeyT, ValueT>> getUnexpiredEntriesInOrder() {
        ArrayList<Map.Entry<KeyT, ValueT>> result = new ArrayList<Map.Entry<KeyT, ValueT>>();
        Object object = this.lock;
        synchronized (object) {
            Entry<KeyT, ValueT> current = this.leastRecent;
            Long currentTime = this.currentTime.get();
            while (current != null) {
                if (!this.isExpired(current, currentTime)) {
                    result.add(new AbstractMap.SimpleImmutableEntry(current.key, current.value));
                }
                current = current.next;
            }
        }
        return result;
    }

    private void unregister(Entry<KeyT, ValueT> v) {
        if (this.leastRecent == v) {
            this.leastRecent = v.next;
        }
        if (this.mostRecent == v) {
            this.mostRecent = v.prev;
        }
        if (v.prev != null) {
            v.prev.next = v.next;
        }
        if (v.next != null) {
            v.next.prev = v.prev;
        }
        v.prev = null;
        v.next = null;
        assert (this.leastRecent == null || this.leastRecent.prev == null);
        assert (this.mostRecent == null || this.mostRecent.next == null);
    }

    private void register(Entry<KeyT, ValueT> e) {
        e.prev = this.mostRecent;
        if (this.mostRecent != null) {
            this.mostRecent.next = e;
        }
        this.mostRecent = e;
        if (this.leastRecent == null) {
            this.leastRecent = e;
        }
        assert (this.map.size() > 0 && this.leastRecent.prev == null && this.mostRecent.next == null);
    }

    private boolean isExpired(Entry<KeyT, ValueT> e, long currentTime) {
        return currentTime - e.lastAccessTime > this.expirationTimeNanos;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxSize() {
        return this.maxSize;
    }

    @NotThreadSafe
    private static class Entry<KeyT, ValueT> {
        final KeyT key;
        final ValueT value;
        long lastAccessTime;
        Entry<KeyT, ValueT> prev;
        Entry<KeyT, ValueT> next;
        boolean replaced = false;

        public String toString() {
            return String.format("%s -> %s", this.key, this.value);
        }

        @ConstructorProperties(value={"key", "value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Entry(KeyT key, ValueT value) {
            this.key = key;
            this.value = value;
        }
    }
}

