/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.implementation.TimeoutTracker;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import reactor.core.publisher.MonoSink;

class RetriableWorkItem {
    private final AtomicInteger retryAttempts = new AtomicInteger();
    private final MonoSink<DeliveryState> monoSink;
    private final TimeoutTracker timeoutTracker;
    private final byte[] amqpMessage;
    private final int messageFormat;
    private final int encodedMessageSize;
    private final DeliveryState deliveryState;
    private boolean waitingForAck;
    private Exception lastKnownException;

    RetriableWorkItem(byte[] amqpMessage, int encodedMessageSize, int messageFormat, MonoSink<DeliveryState> monoSink, Duration timeout, DeliveryState deliveryState) {
        this(amqpMessage, encodedMessageSize, messageFormat, monoSink, new TimeoutTracker(timeout, false), deliveryState);
    }

    private RetriableWorkItem(byte[] amqpMessage, int encodedMessageSize, int messageFormat, MonoSink<DeliveryState> monoSink, TimeoutTracker timeout, DeliveryState deliveryState) {
        this.amqpMessage = amqpMessage;
        this.encodedMessageSize = encodedMessageSize;
        this.messageFormat = messageFormat;
        this.monoSink = monoSink;
        this.timeoutTracker = timeout;
        this.deliveryState = deliveryState;
    }

    byte[] getMessage() {
        return this.amqpMessage;
    }

    DeliveryState getDeliveryState() {
        return this.deliveryState;
    }

    boolean isDeliveryStateProvided() {
        return this.deliveryState != null;
    }

    TimeoutTracker getTimeoutTracker() {
        return this.timeoutTracker;
    }

    void success(DeliveryState deliveryState) {
        this.monoSink.success((Object)deliveryState);
    }

    void error(Throwable error) {
        this.monoSink.error(error);
    }

    int incrementRetryAttempts() {
        return this.retryAttempts.incrementAndGet();
    }

    boolean hasBeenRetried() {
        return this.retryAttempts.get() == 0;
    }

    int getEncodedMessageSize() {
        return this.encodedMessageSize;
    }

    int getMessageFormat() {
        return this.messageFormat;
    }

    Exception getLastKnownException() {
        return this.lastKnownException;
    }

    void setLastKnownException(Exception exception) {
        this.lastKnownException = exception;
    }

    void setWaitingForAck() {
        this.waitingForAck = true;
    }

    boolean isWaitingForAck() {
        return this.waitingForAck;
    }
}

