/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.ParsedSchema;
import io.apicurio.registry.serde.ParsedSchemaImpl;
import io.apicurio.registry.serde.SchemaLookupResult;
import io.apicurio.registry.serde.SchemaParser;
import io.apicurio.registry.serde.SchemaResolverConfigurer;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import io.apicurio.registry.types.ArtifactType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import io.apicurio.registry.utils.converter.json.PrettyFormatStrategy;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.storage.Converter;

public class ExtJsonConverter
extends SchemaResolverConfigurer<JsonNode, Object>
implements Converter,
SchemaParser<JsonNode>,
AutoCloseable {
    private final JsonConverter jsonConverter = new JsonConverter();
    private final ObjectMapper mapper = new ObjectMapper();
    private FormatStrategy formatStrategy = new PrettyFormatStrategy();

    public ExtJsonConverter() {
        this(null);
    }

    public ExtJsonConverter(RegistryClient client) {
        super(client);
    }

    public ExtJsonConverter setFormatStrategy(FormatStrategy formatStrategy) {
        this.formatStrategy = Objects.requireNonNull(formatStrategy);
        return this;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey, (SchemaParser)this);
        HashMap wrapper = new HashMap(configs);
        wrapper.put("schemas.enable", false);
        this.jsonConverter.configure(wrapper, isKey);
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        return this.fromConnectData(topic, null, schema, value);
    }

    public byte[] fromConnectData(String topic, Headers headers, Schema schema, Object value) {
        if (schema == null && value == null) {
            return null;
        }
        ObjectNode jsonSchema = this.jsonConverter.asJsonSchema(schema);
        String schemaString = jsonSchema != null ? jsonSchema.toString() : null;
        ParsedSchemaImpl parsedSchema = new ParsedSchemaImpl().setParsedSchema((Object)jsonSchema).setRawSchema(IoUtil.toBytes((String)schemaString));
        SchemaLookupResult schemaLookupResult = this.getSchemaResolver().resolveSchema(topic, headers, value, (ParsedSchema)parsedSchema);
        byte[] payload = this.jsonConverter.fromConnectData(topic, schema, value);
        return this.formatStrategy.fromConnectData(schemaLookupResult.getGlobalId(), payload);
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        FormatStrategy.IdPayload ip = this.formatStrategy.toConnectData(value);
        long globalId = ip.getGlobalId();
        SchemaLookupResult schemaLookupResult = this.getSchemaResolver().resolveSchemaByArtifactReference(ArtifactReference.builder().globalId(Long.valueOf(globalId)).build());
        Schema schema = this.jsonConverter.asConnectSchema((JsonNode)schemaLookupResult.getSchema());
        byte[] payload = ip.getPayload();
        SchemaAndValue sav = this.jsonConverter.toConnectData(topic, payload);
        return new SchemaAndValue(schema, sav.value());
    }

    public ArtifactType artifactType() {
        return ArtifactType.KCONNECT;
    }

    public JsonNode parseSchema(byte[] rawSchema) {
        try {
            return this.mapper.readTree(rawSchema);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.jsonConverter.close();
    }
}

