/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.server;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Avro;
import io.debezium.engine.format.Json;
import io.debezium.engine.format.Protobuf;
import io.debezium.server.ConnectorLifecycle;
import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.Startup;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class DebeziumServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebeziumServer.class);
    private static final String PROP_PREFIX = "debezium.";
    private static final String PROP_SOURCE_PREFIX = "debezium.source.";
    private static final String PROP_SINK_PREFIX = "debezium.sink.";
    private static final String PROP_FORMAT_PREFIX = "debezium.format.";
    private static final String PROP_TRANSFORMS_PREFIX = "debezium.transforms.";
    private static final String PROP_KEY_FORMAT_PREFIX = "debezium.format.key.";
    private static final String PROP_VALUE_FORMAT_PREFIX = "debezium.format.value.";
    private static final String PROP_TRANSFORMS = "debezium.transforms";
    private static final String PROP_SINK_TYPE = "debezium.sink.type";
    private static final String PROP_KEY_FORMAT = "debezium.format.key";
    private static final String PROP_VALUE_FORMAT = "debezium.format.value";
    private static final String PROP_TERMINATION_WAIT = "debezium.termination.wait";
    private static final String FORMAT_JSON = Json.class.getSimpleName().toLowerCase();
    private static final String FORMAT_AVRO = Avro.class.getSimpleName().toLowerCase();
    private static final String FORMAT_PROTOBUF = Protobuf.class.getSimpleName().toLowerCase();
    private static final Pattern SHELL_PROPERTY_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+_+[a-zA-Z0-9_]+$");
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    @Inject
    BeanManager beanManager;
    @Inject
    @Liveness
    ConnectorLifecycle health;
    private Bean<DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>>> consumerBean;
    private CreationalContext<DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>>> consumerBeanCreationalContext;
    private DebeziumEngine.ChangeConsumer<ChangeEvent<Object, Object>> consumer;
    private DebeziumEngine<?> engine;
    private final Properties props = new Properties();

    @PostConstruct
    public void start() {
        Config config = ConfigProvider.getConfig();
        String name = (String)config.getValue(PROP_SINK_TYPE, String.class);
        Set beans = this.beanManager.getBeans(name).stream().filter(x -> DebeziumEngine.ChangeConsumer.class.isAssignableFrom(x.getBeanClass())).collect(Collectors.toSet());
        LOGGER.debug("Found {} candidate consumer(s)", (Object)beans.size());
        if (beans.size() == 0) {
            throw new DebeziumException("No Debezium consumer named '" + name + "' is available");
        }
        if (beans.size() > 1) {
            throw new DebeziumException("Multiple Debezium consumers named '" + name + "' were found");
        }
        this.consumerBean = (Bean)beans.iterator().next();
        this.consumerBeanCreationalContext = this.beanManager.createCreationalContext(this.consumerBean);
        this.consumer = (DebeziumEngine.ChangeConsumer)this.consumerBean.create(this.consumerBeanCreationalContext);
        LOGGER.info("Consumer '{}' instantiated", (Object)this.consumer.getClass().getName());
        Class<?> keyFormat = this.getFormat(config, PROP_KEY_FORMAT);
        Class<?> valueFormat = this.getFormat(config, PROP_VALUE_FORMAT);
        this.configToProperties(config, this.props, PROP_SOURCE_PREFIX, "");
        this.configToProperties(config, this.props, PROP_FORMAT_PREFIX, "key.converter.");
        this.configToProperties(config, this.props, PROP_FORMAT_PREFIX, "value.converter.");
        this.configToProperties(config, this.props, PROP_KEY_FORMAT_PREFIX, "key.converter.");
        this.configToProperties(config, this.props, PROP_VALUE_FORMAT_PREFIX, "value.converter.");
        Optional transforms = config.getOptionalValue(PROP_TRANSFORMS, String.class);
        if (transforms.isPresent()) {
            this.props.setProperty("transforms", (String)transforms.get());
            this.configToProperties(config, this.props, PROP_TRANSFORMS_PREFIX, "transforms.");
        }
        if (!this.consumer.supportsTombstoneEvents()) {
            this.props.setProperty(CommonConnectorConfig.TOMBSTONES_ON_DELETE.name(), Boolean.FALSE.toString());
        }
        this.props.setProperty("name", name);
        LOGGER.debug("Configuration for DebeziumEngine: {}", (Object)this.props);
        this.engine = DebeziumEngine.create(keyFormat, valueFormat).notifying(this.consumer).using(this.props).using((DebeziumEngine.ConnectorCallback)this.health).using((DebeziumEngine.CompletionCallback)this.health).build();
        this.executor.execute(() -> {
            try {
                this.engine.run();
            }
            finally {
                Quarkus.asyncExit();
            }
        });
        LOGGER.info("Engine executor started");
    }

    private void configToProperties(Config config, Properties props, String oldPrefix, String newPrefix) {
        for (String name : config.getPropertyNames()) {
            String updatedPropertyName = null;
            if (SHELL_PROPERTY_NAME_PATTERN.matcher(name).matches()) {
                updatedPropertyName = name.replace("_", ".").toLowerCase();
            }
            if (updatedPropertyName != null && updatedPropertyName.startsWith(oldPrefix)) {
                props.setProperty(newPrefix + updatedPropertyName.substring(oldPrefix.length()), (String)config.getValue(name, String.class));
                continue;
            }
            if (!name.startsWith(oldPrefix)) continue;
            props.setProperty(newPrefix + name.substring(oldPrefix.length()), (String)config.getValue(name, String.class));
        }
    }

    private Class<?> getFormat(Config config, String property) {
        String formatName = config.getOptionalValue(property, String.class).orElse(FORMAT_JSON);
        if (FORMAT_JSON.equals(formatName)) {
            return Json.class;
        }
        if (FORMAT_AVRO.equals(formatName)) {
            return Avro.class;
        }
        if (FORMAT_PROTOBUF.equals(formatName)) {
            return Protobuf.class;
        }
        throw new DebeziumException("Unknown format '" + formatName + "' for option '" + property + "'");
    }

    public void stop(@Observes ShutdownEvent event) {
        try {
            LOGGER.info("Received request to stop the engine");
            Config config = ConfigProvider.getConfig();
            this.engine.close();
            this.executor.shutdown();
            this.executor.awaitTermination(config.getOptionalValue(PROP_TERMINATION_WAIT, Integer.class).orElse(10).intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            LOGGER.error("Exception while shuttting down Debezium", (Throwable)e);
        }
        this.consumerBean.destroy(this.consumer, this.consumerBeanCreationalContext);
    }

    DebeziumEngine.ChangeConsumer<?> getConsumer() {
        return this.consumer;
    }

    public Properties getProps() {
        return this.props;
    }
}

