/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde.util;

import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AvroEncoding;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

public class HeaderUtils {
    public static final String DEFAULT_HEADER_KEY_ARTIFACT_ID = "apicurio.key.artifactId";
    public static final String DEFAULT_HEADER_VALUE_ARTIFACT_ID = "apicurio.value.artifactId";
    public static final String DEFAULT_HEADER_KEY_VERSION = "apicurio.key.version";
    public static final String DEFAULT_HEADER_VALUE_VERSION = "apicurio.value.version";
    public static final String DEFAULT_HEADER_KEY_GLOBAL_ID = "apicurio.key.globalId";
    public static final String DEFAULT_HEADER_VALUE_GLOBAL_ID = "apicurio.value.globalId";
    public static final String HEADER_KEY_ENCODING = "apicurio.key.encoding";
    public static final String HEADER_VALUE_ENCODING = "apicurio.value.encoding";
    public static final String HEADER_KEY_ARTIFACT_ID_OVERRIDE_NAME = "apicurio.key.artifactId.name";
    public static final String HEADER_VALUE_ARTIFACT_ID_OVERRIDE_NAME = "apicurio.value.artifactId.name";
    public static final String HEADER_KEY_VERSION_OVERRIDE_NAME = "apicurio.key.version.name";
    public static final String HEADER_VALUE_VERSION_OVERRIDE_NAME = "apicurio.value.version.name";
    public static final String HEADER_KEY_GLOBAL_ID_OVERRIDE_NAME = "apicurio.key.globalId.name";
    public static final String HEADER_VALUE_GLOBAL_ID_OVERRIDE_NAME = "apicurio.value.globalId.name";
    protected String globalIdHeaderName;
    protected String artifactIdHeaderName;
    protected String versionHeaderName;
    protected String encodingName;

    public HeaderUtils(Map<String, Object> configs, boolean isKey) {
        if (isKey) {
            this.artifactIdHeaderName = (String)configs.getOrDefault(HEADER_KEY_ARTIFACT_ID_OVERRIDE_NAME, DEFAULT_HEADER_KEY_ARTIFACT_ID);
            this.globalIdHeaderName = (String)configs.getOrDefault(HEADER_KEY_GLOBAL_ID_OVERRIDE_NAME, DEFAULT_HEADER_KEY_GLOBAL_ID);
            this.versionHeaderName = (String)configs.getOrDefault(HEADER_KEY_VERSION_OVERRIDE_NAME, DEFAULT_HEADER_KEY_VERSION);
            this.encodingName = HEADER_KEY_ENCODING;
        } else {
            this.artifactIdHeaderName = (String)configs.getOrDefault(HEADER_VALUE_ARTIFACT_ID_OVERRIDE_NAME, DEFAULT_HEADER_VALUE_ARTIFACT_ID);
            this.globalIdHeaderName = (String)configs.getOrDefault(HEADER_VALUE_GLOBAL_ID_OVERRIDE_NAME, DEFAULT_HEADER_VALUE_GLOBAL_ID);
            this.versionHeaderName = (String)configs.getOrDefault(HEADER_VALUE_VERSION_OVERRIDE_NAME, DEFAULT_HEADER_VALUE_VERSION);
            this.encodingName = HEADER_VALUE_ENCODING;
        }
    }

    public void addSchemaHeaders(Headers headers, String artifactId, long globalId) {
        if (headers == null) {
            headers = HeaderUtils.createHeaders();
        }
        if (globalId >= 0L) {
            ByteBuffer buff = ByteBuffer.allocate(8);
            buff.putLong(globalId);
            headers.add(this.globalIdHeaderName, buff.array());
        } else {
            headers.add(this.artifactIdHeaderName, IoUtil.toBytes((String)artifactId));
        }
    }

    public void addEncodingHeader(Headers headers, AvroEncoding encoding) {
        headers.add((Header)new RecordHeader(this.encodingName, encoding.name().getBytes()));
    }

    public AvroEncoding getEncoding(Headers headers) {
        Header encodingHeader = headers.lastHeader(this.encodingName);
        AvroEncoding encoding = null;
        if (encodingHeader != null) {
            encoding = AvroEncoding.valueOf(IoUtil.toString((byte[])encodingHeader.value()));
        }
        return encoding;
    }

    public String getArtifactId(Headers headers) {
        Header header = headers.lastHeader(this.artifactIdHeaderName);
        if (header == null) {
            throw new RuntimeException("ArtifactId not found in headers.");
        }
        return IoUtil.toString((byte[])header.value());
    }

    public Integer getVersion(Headers headers) {
        Header header = headers.lastHeader(this.versionHeaderName);
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getInt();
    }

    public Long getGlobalId(Headers headers) {
        Header header = headers.lastHeader(this.globalIdHeaderName);
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getLong();
    }

    public static Headers createHeaders() {
        return HeaderUtils.createHeaders(Collections.emptyMap());
    }

    public static Headers createHeaders(final Map<String, String> mapObj) {
        HashMap<String, Header> headersMap = new HashMap<String, Header>();
        for (final String key : mapObj.keySet()) {
            headersMap.put(key, new Header(){

                public String key() {
                    return key;
                }

                public byte[] value() {
                    return ((String)mapObj.get(key)).getBytes();
                }
            });
        }
        return HeaderUtils.fromMap(headersMap);
    }

    private static Headers fromMap(final Map<String, Header> mapObj) {
        return new Headers(){

            public Iterator<Header> iterator() {
                return mapObj.values().iterator();
            }

            public Header[] toArray() {
                return mapObj.values().toArray(new Header[0]);
            }

            public Headers remove(String arg0) throws IllegalStateException {
                mapObj.remove(arg0);
                return HeaderUtils.fromMap(mapObj);
            }

            public Header lastHeader(String arg0) {
                return (Header)mapObj.get(arg0);
            }

            public Iterable<Header> headers(String arg0) {
                return mapObj.values();
            }

            public Headers add(final String arg0, final byte[] arg1) throws IllegalStateException {
                Header newHeader = new Header(){

                    public String key() {
                        return arg0;
                    }

                    public byte[] value() {
                        return arg1;
                    }
                };
                mapObj.put(arg0, newHeader);
                return HeaderUtils.fromMap(mapObj);
            }

            public Headers add(Header arg0) throws IllegalStateException {
                mapObj.put(arg0.key(), arg0);
                return HeaderUtils.fromMap(mapObj);
            }
        };
    }
}

