/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.serde;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.worldturner.medeia.api.SchemaSource;
import com.worldturner.medeia.api.StringSchemaSource;
import com.worldturner.medeia.api.jackson.MedeiaJacksonApi;
import com.worldturner.medeia.schema.validation.SchemaValidator;
import io.apicurio.registry.client.RegistryService;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.serde.AbstractKafkaStrategyAwareSerDe;
import io.apicurio.registry.utils.serde.SchemaCache;
import io.apicurio.registry.utils.serde.util.Utils;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.core.Response;

public class JsonSchemaKafkaSerDe<S extends JsonSchemaKafkaSerDe<S>>
extends AbstractKafkaStrategyAwareSerDe<SchemaValidator, S> {
    protected static MedeiaJacksonApi api = new MedeiaJacksonApi();
    protected static ObjectMapper mapper = new ObjectMapper();
    private Boolean validationEnabled;
    private SchemaCache<SchemaValidator> schemaCache;

    public JsonSchemaKafkaSerDe() {
        this(null, null);
    }

    public JsonSchemaKafkaSerDe(RegistryService client, Boolean validationEnabled) {
        super(client);
        this.validationEnabled = validationEnabled;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public S setValidationEnabled(boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
        return (S)((JsonSchemaKafkaSerDe)this.self());
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        if (this.validationEnabled == null) {
            Object ve = configs.get("apicurio.registry.serdes.json-schema.validation-enabled");
            this.validationEnabled = Utils.isTrue(ve);
        }
    }

    protected SchemaCache<SchemaValidator> getSchemaCache() {
        if (this.schemaCache == null) {
            this.schemaCache = new SchemaCache<SchemaValidator>(this.getClient()){

                @Override
                protected SchemaValidator toSchema(Response response) {
                    Object responseEntity = response.getEntity();
                    String schema = responseEntity instanceof InputStream ? IoUtil.toString((InputStream)((InputStream)responseEntity)) : (String)response.readEntity(String.class);
                    return api.loadSchema((SchemaSource)new StringSchemaSource(schema));
                }
            };
        }
        return this.schemaCache;
    }
}

