/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.implementation.AmqpConstants;
import com.azure.core.amqp.implementation.AmqpSendLink;
import com.azure.core.amqp.implementation.ErrorContextProvider;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.implementation.EventHubConnectionProcessor;
import com.azure.messaging.eventhubs.implementation.EventHubManagementNode;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;
import com.azure.messaging.eventhubs.models.SendOptions;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class EventHubProducerAsyncClient
implements Closeable {
    private static final int MAX_PARTITION_KEY_LENGTH = 128;
    private static final String SENDER_ENTITY_PATH_FORMAT = "%s/Partitions/%s";
    private static final SendOptions DEFAULT_SEND_OPTIONS = new SendOptions();
    private static final CreateBatchOptions DEFAULT_BATCH_OPTIONS = new CreateBatchOptions();
    private final ClientLogger logger = new ClientLogger(EventHubProducerAsyncClient.class);
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final String fullyQualifiedNamespace;
    private final String eventHubName;
    private final EventHubConnectionProcessor connectionProcessor;
    private final AmqpRetryOptions retryOptions;
    private final AmqpRetryPolicy retryPolicy;
    private final TracerProvider tracerProvider;
    private final MessageSerializer messageSerializer;
    private final Scheduler scheduler;
    private final boolean isSharedConnection;
    private final Runnable onClientClose;

    EventHubProducerAsyncClient(String fullyQualifiedNamespace, String eventHubName, EventHubConnectionProcessor connectionProcessor, AmqpRetryOptions retryOptions, TracerProvider tracerProvider, MessageSerializer messageSerializer, Scheduler scheduler, boolean isSharedConnection, Runnable onClientClose) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.eventHubName = Objects.requireNonNull(eventHubName, "'eventHubName' cannot be null.");
        this.connectionProcessor = Objects.requireNonNull(connectionProcessor, "'connectionProcessor' cannot be null.");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        this.tracerProvider = Objects.requireNonNull(tracerProvider, "'tracerProvider' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        this.retryPolicy = RetryUtil.getRetryPolicy((AmqpRetryOptions)retryOptions);
        this.scheduler = scheduler;
        this.isSharedConnection = isSharedConnection;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public Mono<EventHubProperties> getEventHubProperties() {
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(EventHubManagementNode::getEventHubProperties);
    }

    public Flux<String> getPartitionIds() {
        return this.getEventHubProperties().flatMapMany(properties -> Flux.fromIterable(properties.getPartitionIds()));
    }

    public Mono<PartitionProperties> getPartitionProperties(String partitionId) {
        return this.connectionProcessor.flatMap(connection -> connection.getManagementNode()).flatMap(node -> node.getPartitionProperties(partitionId));
    }

    public Mono<EventDataBatch> createBatch() {
        return this.createBatch(DEFAULT_BATCH_OPTIONS);
    }

    public Mono<EventDataBatch> createBatch(CreateBatchOptions options) {
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        String partitionKey = options.getPartitionKey();
        String partitionId = options.getPartitionId();
        int batchMaxSize = options.getMaximumSizeInBytes();
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && !CoreUtils.isNullOrEmpty((CharSequence)partitionId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "CreateBatchOptions.getPartitionKey() and CreateBatchOptions.getPartitionId() are both set. Only one or the other can be used. partitionKey: '%s'. partitionId: '%s'", partitionKey, partitionId)));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && partitionKey.length() > 128) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "Partition key '%s' exceeds the maximum allowed length: '%s'.", partitionKey, 128)));
        }
        return this.getSendLink(partitionId).flatMap(link -> link.getLinkSize().flatMap(size -> {
            int maximumLinkSize;
            int n = maximumLinkSize = size > 0 ? size : 262144;
            if (batchMaxSize > maximumLinkSize) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "BatchOptions.maximumSizeInBytes (%s bytes) is larger than the link size (%s bytes).", batchMaxSize, maximumLinkSize)));
            }
            int batchSize = batchMaxSize > 0 ? batchMaxSize : maximumLinkSize;
            return Mono.just((Object)new EventDataBatch(batchSize, partitionId, partitionKey, () -> ((AmqpSendLink)link).getErrorContext(), this.tracerProvider, link.getEntityPath(), link.getHostname()));
        }));
    }

    Mono<Void> send(EventData event) {
        if (event == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'event' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.just((Object)event));
    }

    Mono<Void> send(EventData event, SendOptions options) {
        if (event == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'event' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.just((Object)event), options);
    }

    public Mono<Void> send(Iterable<EventData> events) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.fromIterable(events));
    }

    public Mono<Void> send(Iterable<EventData> events, SendOptions options) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.send((Flux<EventData>)Flux.fromIterable(events), options);
    }

    Mono<Void> send(Flux<EventData> events) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        return this.send(events, DEFAULT_SEND_OPTIONS);
    }

    Mono<Void> send(Flux<EventData> events, SendOptions options) {
        if (events == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'events' cannot be null."));
        }
        if (options == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'options' cannot be null."));
        }
        return this.sendInternal(events, options).publishOn(this.scheduler);
    }

    public Mono<Void> send(EventDataBatch batch) {
        if (batch == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'batch' cannot be null."));
        }
        if (batch.getEvents().isEmpty()) {
            this.logger.warning(Messages.CANNOT_SEND_EVENT_BATCH_EMPTY);
            return Mono.empty();
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)batch.getPartitionId())) {
            this.logger.verbose("Sending batch with size[{}] to partitionId[{}].", new Object[]{batch.getCount(), batch.getPartitionId()});
        } else if (!CoreUtils.isNullOrEmpty((CharSequence)batch.getPartitionKey())) {
            this.logger.verbose("Sending batch with size[{}] with partitionKey[{}].", new Object[]{batch.getCount(), batch.getPartitionKey()});
        } else {
            this.logger.verbose("Sending batch with size[{}] to be distributed round-robin in service.", new Object[]{batch.getCount()});
        }
        String partitionKey = batch.getPartitionKey();
        boolean isTracingEnabled = this.tracerProvider.isEnabled();
        AtomicReference<Context> parentContext = isTracingEnabled ? new AtomicReference<Context>(Context.NONE) : null;
        Context sharedContext = null;
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < batch.getEvents().size(); ++i) {
            EventData event = batch.getEvents().get(i);
            if (isTracingEnabled) {
                parentContext.set(event.getContext());
                if (i == 0) {
                    sharedContext = this.tracerProvider.getSharedSpanBuilder(parentContext.get());
                }
                this.tracerProvider.addSpanLinks(sharedContext.addData((Object)"span-context", (Object)event.getContext()));
            }
            Message message = this.messageSerializer.serialize((Object)event);
            if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey)) {
                MessageAnnotations messageAnnotations = message.getMessageAnnotations() == null ? new MessageAnnotations(new HashMap()) : message.getMessageAnnotations();
                messageAnnotations.getValue().put(AmqpConstants.PARTITION_KEY, partitionKey);
                message.setMessageAnnotations(messageAnnotations);
            }
            messages.add(message);
        }
        if (isTracingEnabled) {
            Context finalSharedContext = sharedContext == null ? Context.NONE : sharedContext.addData((Object)"entity-path", (Object)this.eventHubName).addData((Object)"hostname", (Object)this.fullyQualifiedNamespace).addData((Object)"az.namespace", (Object)"Microsoft.EventHub");
            parentContext.set(this.tracerProvider.startSpan(finalSharedContext, ProcessKind.SEND));
        }
        return RetryUtil.withRetry((Mono)this.getSendLink(batch.getPartitionId()).flatMap(link -> messages.size() == 1 ? link.send((Message)messages.get(0)) : link.send(messages)), (Duration)this.retryOptions.getTryTimeout(), (AmqpRetryPolicy)this.retryPolicy).publishOn(this.scheduler).doOnEach(signal -> {
            if (isTracingEnabled) {
                this.tracerProvider.endSpan((Context)parentContext.get(), signal);
            }
        });
    }

    private Mono<Void> sendInternal(Flux<EventData> events, SendOptions options) {
        String partitionKey = options.getPartitionKey();
        String partitionId = options.getPartitionId();
        if (!CoreUtils.isNullOrEmpty((CharSequence)partitionKey) && !CoreUtils.isNullOrEmpty((CharSequence)partitionId)) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException(String.format(Locale.US, "SendOptions.getPartitionKey() and SendOptions.getPartitionId() are both set. Only one or the other can be used. partitionKey: '%s'. partitionId: '%s'", partitionKey, partitionId)));
        }
        return this.getSendLink(options.getPartitionId()).flatMap(link -> link.getLinkSize().flatMap(size -> {
            int batchSize = size > 0 ? size : 262144;
            CreateBatchOptions batchOptions = new CreateBatchOptions().setPartitionKey(options.getPartitionKey()).setPartitionId(options.getPartitionId()).setMaximumSizeInBytes(batchSize);
            return events.collect((Collector)new EventDataCollector(batchOptions, 1, () -> ((AmqpSendLink)link).getErrorContext(), this.tracerProvider, link.getEntityPath(), link.getHostname()));
        }).flatMap(list -> this.sendInternal((Flux<EventDataBatch>)Flux.fromIterable((Iterable)list))));
    }

    private Mono<Void> sendInternal(Flux<EventDataBatch> eventBatches) {
        return eventBatches.flatMap(this::send).then().doOnError(error -> this.logger.error(Messages.ERROR_SENDING_BATCH, new Object[]{error}));
    }

    private String getEntityPath(String partitionId) {
        return CoreUtils.isNullOrEmpty((CharSequence)partitionId) ? this.eventHubName : String.format(Locale.US, SENDER_ENTITY_PATH_FORMAT, this.eventHubName, partitionId);
    }

    private Mono<AmqpSendLink> getSendLink(String partitionId) {
        String entityPath = this.getEntityPath(partitionId);
        String linkName = this.getEntityPath(partitionId);
        return this.connectionProcessor.flatMap(connection -> connection.createSendLink(linkName, entityPath, this.retryOptions));
    }

    @Override
    public void close() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        if (this.isSharedConnection) {
            this.onClientClose.run();
        } else {
            this.connectionProcessor.dispose();
        }
    }

    private static class EventDataCollector
    implements Collector<EventData, List<EventDataBatch>, List<EventDataBatch>> {
        private final String partitionKey;
        private final String partitionId;
        private final int maxMessageSize;
        private final Integer maxNumberOfBatches;
        private final ErrorContextProvider contextProvider;
        private final TracerProvider tracerProvider;
        private final String entityPath;
        private final String hostname;
        private volatile EventDataBatch currentBatch;

        EventDataCollector(CreateBatchOptions options, Integer maxNumberOfBatches, ErrorContextProvider contextProvider, TracerProvider tracerProvider, String entityPath, String hostname) {
            this.maxNumberOfBatches = maxNumberOfBatches;
            this.maxMessageSize = options.getMaximumSizeInBytes() > 0 ? options.getMaximumSizeInBytes() : 262144;
            this.partitionKey = options.getPartitionKey();
            this.partitionId = options.getPartitionId();
            this.contextProvider = contextProvider;
            this.tracerProvider = tracerProvider;
            this.entityPath = entityPath;
            this.hostname = hostname;
            this.currentBatch = new EventDataBatch(this.maxMessageSize, this.partitionId, this.partitionKey, contextProvider, tracerProvider, entityPath, hostname);
        }

        @Override
        public Supplier<List<EventDataBatch>> supplier() {
            return ArrayList::new;
        }

        @Override
        public BiConsumer<List<EventDataBatch>, EventData> accumulator() {
            return (list, event) -> {
                EventDataBatch batch = this.currentBatch;
                if (batch.tryAdd((EventData)event)) {
                    return;
                }
                if (this.maxNumberOfBatches != null && list.size() == this.maxNumberOfBatches.intValue()) {
                    String message = String.format(Locale.US, Messages.EVENT_DATA_DOES_NOT_FIT, this.maxNumberOfBatches);
                    throw new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, message, this.contextProvider.getErrorContext());
                }
                this.currentBatch = new EventDataBatch(this.maxMessageSize, this.partitionId, this.partitionKey, this.contextProvider, this.tracerProvider, this.entityPath, this.hostname);
                this.currentBatch.tryAdd((EventData)event);
                list.add(batch);
            };
        }

        @Override
        public BinaryOperator<List<EventDataBatch>> combiner() {
            return (existing, another) -> {
                existing.addAll(another);
                return existing;
            };
        }

        @Override
        public Function<List<EventDataBatch>, List<EventDataBatch>> finisher() {
            return list -> {
                EventDataBatch batch = this.currentBatch;
                this.currentBatch = null;
                if (batch != null) {
                    list.add(batch);
                }
                return list;
            };
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

