/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.Configuration;
import io.debezium.connector.common.RelationalBaseSourceConnector;
import io.debezium.connector.sqlserver.Module;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerConnectorTask;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerConnector
extends RelationalBaseSourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlServerConnector.class);
    private Map<String, String> properties;

    public String version() {
        return Module.version();
    }

    public void start(Map<String, String> props) {
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(props));
    }

    public Class<? extends Task> taskClass() {
        return SqlServerConnectorTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        if (maxTasks > 1) {
            throw new IllegalArgumentException("Only a single connector task may be started");
        }
        return Collections.singletonList(this.properties);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return SqlServerConnectorConfig.configDef();
    }

    protected void validateConnection(Map<String, ConfigValue> configValues, Configuration config) {
        ConfigValue databaseValue = configValues.get(RelationalDatabaseConnectorConfig.DATABASE_NAME.name());
        if (!databaseValue.errorMessages().isEmpty()) {
            return;
        }
        ConfigValue hostnameValue = configValues.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue userValue = configValues.get(RelationalDatabaseConnectorConfig.USER.name());
        SqlServerConnectorConfig sqlServerConfig = new SqlServerConnectorConfig(config);
        try (SqlServerConnection connection = new SqlServerConnection(sqlServerConfig.jdbcConfig(), Clock.system(), sqlServerConfig.getSourceTimestampMode(), null);){
            LOGGER.debug("Successfully tested connection for {} with user '{}'", (Object)connection.connectionString(), (Object)connection.username());
        }
        catch (Exception e) {
            LOGGER.error("Failed testing connection for {} with user '{}'", new Object[]{config.withMaskedPasswords(), userValue, e});
            hostnameValue.addErrorMessage("Unable to connect. Check this and other connection properties. Error: " + e.getMessage());
        }
    }

    protected Map<String, ConfigValue> validateAllFields(Configuration config) {
        return config.validate(SqlServerConnectorConfig.ALL_FIELDS);
    }
}

