/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.common.collect.ImmutableList;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.alts.CheckGcpEnvironment;
import io.grpc.alts.FailingCallCredentials;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.util.List;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7479")
public final class ComputeEngineChannelCredentials {
    private ComputeEngineChannelCredentials() {
    }

    public static ChannelCredentials create() {
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create((InternalProtocolNegotiator.ClientFactory)ComputeEngineChannelCredentials.createClientFactory());
        Object callCredentials = CheckGcpEnvironment.isOnGcp() ? MoreCallCredentials.from((Credentials)ComputeEngineCredentials.create()) : new FailingCallCredentials(Status.INTERNAL.withDescription("Compute Engine Credentials can only be used on Google Cloud Platform"));
        return CompositeChannelCredentials.create((ChannelCredentials)nettyCredentials, (CallCredentials)callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory((List<String>)ImmutableList.of(), (ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

