/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbSnapshotChangeEventSource;
import io.debezium.connector.mongodb.MongoDbStreamingChangeEventSource;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.util.Clock;

public class MongoDbChangeEventSourceFactory
implements ChangeEventSourceFactory {
    private final MongoDbConnectorConfig configuration;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<CollectionId> dispatcher;
    private final Clock clock;
    private final ReplicaSets replicaSets;
    private final MongoDbTaskContext taskContext;

    public MongoDbChangeEventSourceFactory(MongoDbConnectorConfig configuration, ErrorHandler errorHandler, EventDispatcher<CollectionId> dispatcher, Clock clock, ReplicaSets replicaSets, MongoDbTaskContext taskContext) {
        this.configuration = configuration;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.replicaSets = replicaSets;
        this.taskContext = taskContext;
    }

    public SnapshotChangeEventSource getSnapshotChangeEventSource(OffsetContext offsetContext, SnapshotProgressListener snapshotProgressListener) {
        return new MongoDbSnapshotChangeEventSource(this.configuration, this.taskContext, this.replicaSets, (MongoDbOffsetContext)offsetContext, this.dispatcher, this.clock, snapshotProgressListener, this.errorHandler);
    }

    public StreamingChangeEventSource getStreamingChangeEventSource(OffsetContext offsetContext) {
        return new MongoDbStreamingChangeEventSource(this.configuration, this.taskContext, this.replicaSets, (MongoDbOffsetContext)offsetContext, this.dispatcher, this.errorHandler, this.clock);
    }
}

