/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.util;

import com.worldturner.util.UriKt;
import java.net.URI;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0001\u001a\u001c\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\b\u001a\u0012\u0010\r\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"EMPTY_URI", "Ljava/net/URI;", "getEMPTY_URI", "()Ljava/net/URI;", "encodeConservatively", "", "s", "hasAnyOtherThanFragment", "", "hasFragment", "replaceFragment", "fragment", "encoded", "resolveSafe", "relative", "withEmptyFragment", "withoutFragment", "medeia-validator-core"})
public final class UriKt {
    @NotNull
    private static final URI EMPTY_URI;

    public static final boolean hasAnyOtherThanFragment(@NotNull URI $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        CharSequence charSequence = $receiver.getRawAuthority();
        return !(charSequence == null || charSequence.length() == 0) || !((charSequence = (CharSequence)$receiver.getRawPath()) == null || charSequence.length() == 0) || !((charSequence = (CharSequence)$receiver.getRawQuery()) == null || charSequence.length() == 0) || !((charSequence = (CharSequence)$receiver.getRawSchemeSpecificPart()) == null || charSequence.length() == 0) || !((charSequence = (CharSequence)$receiver.getRawUserInfo()) == null || charSequence.length() == 0);
    }

    public static final boolean hasFragment(@NotNull URI $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getFragment() != null;
    }

    @NotNull
    public static final URI withoutFragment(@NotNull URI $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String string = $receiver.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.toString()");
        return new URI(StringKt.replaceFromLast$default(string, '#', "", null, 4, null));
    }

    @NotNull
    public static final URI withEmptyFragment(@NotNull URI $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String it = string = $receiver.toString();
        boolean bl = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
        return new URI(StringsKt.replaceAfterLast((String)string2, (char)'#', (String)"", (String)(it + '#')));
    }

    @NotNull
    public static final URI replaceFragment(@NotNull URI $receiver, @NotNull String fragment, boolean encoded) {
        URI uRI;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        try {
            String string;
            if (UriKt.hasFragment($receiver)) {
                String string2 = $receiver.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.toString()");
                string = StringsKt.replaceAfter$default((String)string2, (char)'#', (String)(encoded ? UriKt.encodeConservatively(fragment) : fragment), null, (int)4, null);
            } else {
                string = $receiver + '#' + (encoded ? UriKt.encodeConservatively(fragment) : fragment);
            }
            URI uRI2 = URI.create(string);
            if (uRI2 == null) {
                Intrinsics.throwNpe();
            }
            uRI = uRI2;
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)e;
        }
        return uRI;
    }

    @NotNull
    public static /* synthetic */ URI replaceFragment$default(URI uRI, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return UriKt.replaceFragment(uRI, string, bl);
    }

    @NotNull
    public static final String encodeConservatively(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        CharSequence charSequence = s;
        Regex regex = new Regex("[\\\\|#<>\\^%\\[\\]{}\" ]");
        Function1 function1 = encodeConservatively.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final URI resolveSafe(@NotNull URI $receiver, @NotNull URI relative) {
        URI uRI;
        URI uRI2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)relative, (String)"relative");
        URI $receiver2 = uRI2 = $receiver;
        boolean bl = false;
        String string = relative.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"relative.toString()");
        String relativeStr = string;
        if (StringsKt.startsWith$default((String)relativeStr, (String)"#", (boolean)false, (int)2, null)) {
            String string2 = relativeStr;
            int n = 1;
            URI uRI3 = $receiver2;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            uRI = UriKt.replaceFragment$default(uRI3, string5, false, 2, null);
        } else {
            uRI = $receiver2.resolve(relative);
            if (uRI == null) {
                Intrinsics.throwNpe();
            }
        }
        return uRI;
    }

    @NotNull
    public static final URI getEMPTY_URI() {
        return EMPTY_URI;
    }

    static {
        URI uRI = URI.create("");
        if (uRI == null) {
            Intrinsics.throwNpe();
        }
        EMPTY_URI = uRI;
    }
}

