/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser;

import com.worldturner.medeia.parser.JsonTokenData$WhenMappings;
import com.worldturner.medeia.parser.JsonTokenDataKt;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.schema.validation.HashResult;
import com.worldturner.medeia.schema.validation.NodeHasher;
import com.worldturner.util.JsonKt;
import com.worldturner.util.MessageDigestsKt;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 ,2\u00020\u00012\u00020\u0002:\u0001,B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0006\u0010#\u001a\u00020!J\b\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020!J\u0006\u0010'\u001a\u00020!J\u000e\u0010(\u001a\n )*\u0004\u0018\u00010\f0\fJ\b\u0010*\u001a\u00020\u0006H\u0016J\b\u0010+\u001a\u0004\u0018\u00010\u0019R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/worldturner/medeia/parser/JsonTokenData;", "Lcom/worldturner/medeia/schema/validation/NodeHasher;", "Lcom/worldturner/medeia/schema/validation/HashResult;", "type", "Lcom/worldturner/medeia/parser/JsonTokenType;", "text", "", "longValue", "", "integer", "Ljava/math/BigInteger;", "decimal", "Ljava/math/BigDecimal;", "(Lcom/worldturner/medeia/parser/JsonTokenType;Ljava/lang/String;JLjava/math/BigInteger;Ljava/math/BigDecimal;)V", "getDecimal", "()Ljava/math/BigDecimal;", "getInteger", "()Ljava/math/BigInteger;", "getLongValue", "()J", "getText", "()Ljava/lang/String;", "getType", "()Lcom/worldturner/medeia/parser/JsonTokenType;", "value", "", "getValue", "()Ljava/lang/Object;", "digest", "", "digester", "Ljava/security/MessageDigest;", "equals", "", "other", "hasLongValue", "hashCode", "", "isInteger", "toBoolean", "toDecimal", "kotlin.jvm.PlatformType", "toString", "toValue", "Companion", "medeia-validator-core"})
public final class JsonTokenData
implements NodeHasher,
HashResult {
    @Nullable
    private final BigDecimal decimal;
    @NotNull
    private final JsonTokenType type;
    @Nullable
    private final String text;
    private final long longValue;
    @Nullable
    private final BigInteger integer;
    private static final int minLongValue = -127;
    private static final int maxLongValue = 127;
    @NotNull
    private static final JsonTokenData[] array;
    public static final Companion Companion;

    @Nullable
    public final BigDecimal getDecimal() {
        return this.decimal;
    }

    public final boolean toBoolean() {
        boolean bl;
        switch (JsonTokenData$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException(String.valueOf((Object)this.type));
            }
        }
        return bl;
    }

    public final boolean hasLongValue() {
        return this.longValue != Long.MIN_VALUE;
    }

    public final BigDecimal toDecimal() {
        BigDecimal bigDecimal;
        if (this.hasLongValue()) {
            bigDecimal = BigDecimal.valueOf(this.longValue);
        } else {
            BigInteger bigInteger = this.integer;
            if (bigInteger != null) {
                BigInteger bigInteger2 = bigInteger;
                bigDecimal = new BigDecimal(bigInteger2);
            } else {
                bigDecimal = this.decimal;
                if (bigDecimal == null) {
                    Intrinsics.throwNpe();
                }
            }
        }
        return bigDecimal;
    }

    @Nullable
    public final Object getValue() {
        Object object;
        Object object2 = this.text;
        if (object2 == null) {
            object2 = object = this.integer;
        }
        if (object2 == null) {
            object = this.decimal;
        }
        return object;
    }

    @Override
    public void digest(@NotNull MessageDigest digester) {
        block3: {
            Object it;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)digester, (String)"digester");
            digester.update((byte)1);
            digester.update((byte)this.type.ordinal());
            if (this.hasLongValue()) {
                MessageDigestsKt.updateValue(digester, this.longValue);
            }
            String string = this.text;
            if (string != null) {
                it = object = string;
                boolean bl = false;
                MessageDigestsKt.updateValue(digester, this.text);
            }
            BigInteger bigInteger = this.integer;
            if (bigInteger != null) {
                it = object = bigInteger;
                boolean bl = false;
                MessageDigestsKt.updateValue(digester, this.integer);
            }
            BigDecimal bigDecimal = this.decimal;
            if (bigDecimal == null) break block3;
            it = object = bigDecimal;
            boolean bl = false;
            MessageDigestsKt.updateValue(digester, this.decimal);
        }
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.worldturner.medeia.parser.JsonTokenData");
        }
        JsonTokenData cfr_ignored_0 = (JsonTokenData)object2;
        if (this.type != ((JsonTokenData)other).type) {
            return false;
        }
        switch (JsonTokenData$WhenMappings.$EnumSwitchMapping$1[this.type.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)this.text, (Object)((JsonTokenData)other).text);
                break;
            }
            case 2: {
                if (this.integer != null && ((JsonTokenData)other).integer != null) {
                    bl = Intrinsics.areEqual((Object)this.integer, (Object)((JsonTokenData)other).integer);
                    break;
                }
                if (this.decimal != null && ((JsonTokenData)other).decimal != null) {
                    if (this.decimal.compareTo(((JsonTokenData)other).decimal) == 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                bl = Intrinsics.areEqual((Object)this.toDecimal(), (Object)((JsonTokenData)other).toDecimal());
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        String string = this.text;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        BigInteger bigInteger = this.integer;
        result = 31 * result + (bigInteger != null ? JsonTokenDataKt.standardizedHashCode(bigInteger) : 0);
        BigDecimal bigDecimal = this.decimal;
        result = 31 * result + (bigDecimal != null ? JsonTokenDataKt.standardizedHashCode(bigDecimal) : 0);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInteger() {
        if (this.hasLongValue()) return true;
        if (this.integer != null) return true;
        BigDecimal bigDecimal = this.decimal;
        if (bigDecimal == null) {
            Intrinsics.throwNpe();
        }
        if (!JsonTokenDataKt.isIntegerForStrippedTrailingZeroes(bigDecimal)) return false;
        return true;
    }

    @NotNull
    public String toString() {
        Object object;
        switch (JsonTokenData$WhenMappings.$EnumSwitchMapping$2[this.type.ordinal()]) {
            case 1: {
                object = "[";
                break;
            }
            case 2: {
                object = "]";
                break;
            }
            case 3: {
                if (this.hasLongValue()) {
                    object = String.valueOf(this.longValue);
                    break;
                }
                object = this.integer;
                if (object != null && (object = ((BigInteger)object).toString()) != null) break;
                BigDecimal bigDecimal = this.decimal;
                String string = bigDecimal != null ? bigDecimal.toString() : null;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                object = string;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"decimal?.toString()!!");
                break;
            }
            case 4: {
                object = "{";
                break;
            }
            case 5: {
                object = "}";
                break;
            }
            case 6: {
                String string = this.text;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = JsonKt.appendJsonString(new StringBuilder(string.length() + 2), this.text).toString();
                object = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder(text!!.len\u2026onString(text).toString()");
                break;
            }
            case 7: {
                object = "null";
                break;
            }
            case 8: {
                object = "true";
                break;
            }
            case 9: {
                object = "false";
                break;
            }
            default: {
                object = "?";
            }
        }
        return object;
    }

    @Nullable
    public final Object toValue() {
        Object object;
        switch (JsonTokenData$WhenMappings.$EnumSwitchMapping$3[this.type.ordinal()]) {
            case 1: {
                if (this.hasLongValue()) {
                    object = this.longValue;
                    break;
                }
                object = this.integer;
                if (object != null || (object = this.decimal) != null) break;
                Intrinsics.throwNpe();
                break;
            }
            case 2: {
                object = this.text;
                if (object != null) break;
                Intrinsics.throwNpe();
                break;
            }
            case 3: {
                object = null;
                break;
            }
            case 4: {
                object = true;
                break;
            }
            case 5: {
                object = false;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Token of type " + (Object)((Object)this.type) + " can't be expressed as a value");
            }
        }
        return object;
    }

    @NotNull
    public final JsonTokenType getType() {
        return this.type;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final long getLongValue() {
        return this.longValue;
    }

    @Nullable
    public final BigInteger getInteger() {
        return this.integer;
    }

    public JsonTokenData(@NotNull JsonTokenType type, @Nullable String text, long longValue, @Nullable BigInteger integer, @Nullable BigDecimal decimal) {
        BigDecimal bigDecimal;
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.type = type;
        this.text = text;
        this.longValue = longValue;
        this.integer = integer;
        JsonTokenData jsonTokenData = this;
        BigDecimal bigDecimal2 = decimal;
        if (bigDecimal2 != null) {
            BigDecimal bigDecimal3 = bigDecimal2;
            JsonTokenData jsonTokenData2 = jsonTokenData;
            BigDecimal it = bigDecimal3;
            boolean bl = false;
            BigDecimal bigDecimal4 = it.stripTrailingZeros();
            jsonTokenData = jsonTokenData2;
            bigDecimal = bigDecimal4;
        } else {
            bigDecimal = null;
        }
        jsonTokenData.decimal = bigDecimal;
    }

    public /* synthetic */ JsonTokenData(JsonTokenType jsonTokenType, String string, long l, BigInteger bigInteger, BigDecimal bigDecimal, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            l = Long.MIN_VALUE;
        }
        if ((n & 8) != 0) {
            bigInteger = null;
        }
        if ((n & 0x10) != 0) {
            bigDecimal = null;
        }
        this(jsonTokenType, string, l, bigInteger, bigDecimal);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Companion = new Companion(null);
        minLongValue = -127;
        maxLongValue = 127;
        int size$iv = maxLongValue - minLongValue + 1;
        JsonTokenData[] result$iv = new JsonTokenData[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            void it;
            JsonTokenData jsonTokenData;
            void i$iv;
            void var4_4 = i$iv;
            void var8_7 = i$iv++;
            JsonTokenData[] jsonTokenDataArray = result$iv;
            boolean bl = false;
            jsonTokenDataArray[var8_7] = jsonTokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, (long)minLongValue + (long)it, null, null, 26, null);
        }
        array = var1_1;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/worldturner/medeia/parser/JsonTokenData$Companion;", "", "()V", "array", "", "Lcom/worldturner/medeia/parser/JsonTokenData;", "getArray", "()[Lcom/worldturner/medeia/parser/JsonTokenData;", "[Lcom/worldturner/medeia/parser/JsonTokenData;", "maxLongValue", "", "getMaxLongValue", "()I", "minLongValue", "getMinLongValue", "createNumber", "longValue", "", "createText", "text", "", "medeia-validator-core"})
    public static final class Companion {
        public final int getMinLongValue() {
            return minLongValue;
        }

        public final int getMaxLongValue() {
            return maxLongValue;
        }

        @NotNull
        public final JsonTokenData[] getArray() {
            return array;
        }

        @NotNull
        public final JsonTokenData createText(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            CharSequence charSequence = text;
            return charSequence.length() == 0 ? JsonTokenDataKt.getTOKEN_EMPTY_STRING() : new JsonTokenData(JsonTokenType.VALUE_TEXT, text, 0L, null, null, 28, null);
        }

        @NotNull
        public final JsonTokenData createNumber(long longValue) {
            long l = longValue;
            return (long)this.getMinLongValue() <= l && (long)this.getMaxLongValue() >= l ? this.getArray()[(int)longValue - this.getMinLongValue()] : (longValue == Long.MIN_VALUE ? new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, BigInteger.valueOf(longValue), null, 22, null) : new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, longValue, null, null, 26, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

